/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.support;

import jakarta.annotation.PreDestroy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.flowable.support.DropdownFormType;
import org.apache.syncope.core.flowable.support.PasswordFormType;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.impl.el.ProcessExpressionManager;
import org.flowable.engine.impl.util.EngineServiceUtil;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

public class DomainProcessEngineFactoryBean
implements FactoryBean<DomainProcessEngine>,
SyncopeCoreLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainProcessEngineFactoryBean.class);
    protected final ApplicationContext ctx;
    protected DomainProcessEngine engine;

    public DomainProcessEngineFactoryBean(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public int getOrder() {
        return 300;
    }

    protected ProcessEngine build(DataSource datasource) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.ctx.getBean("domainTransactionManager", PlatformTransactionManager.class);
        SpringProcessEngineConfiguration conf = (SpringProcessEngineConfiguration)this.ctx.getBean(SpringProcessEngineConfiguration.class);
        conf.setDataSource(datasource);
        conf.setTransactionManager(transactionManager);
        conf.setTransactionsExternallyManaged(true);
        conf.setJpaEntityManagerFactory(this.ctx.getBean("entityManagerFactory"));
        if (conf.getBeans() == null) {
            conf.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.ctx));
        }
        if (conf.getExpressionManager() == null) {
            conf.setExpressionManager((ExpressionManager)new ProcessExpressionManager(conf.getBeans()));
        }
        if (EngineServiceUtil.getIdmEngineConfiguration((AbstractEngineConfiguration)conf) == null) {
            SpringIdmEngineConfiguration spiec = (SpringIdmEngineConfiguration)this.ctx.getBean(SpringIdmEngineConfiguration.class);
            conf.addEngineConfiguration(spiec.getEngineCfgKey(), spiec.getEngineScopeType(), (AbstractEngineConfiguration)spiec);
        }
        conf.setEnableSafeBpmnXml(true);
        conf.setCustomFormTypes(List.of(new DropdownFormType(null), new PasswordFormType()));
        conf.setDisableEventRegistry(true);
        return conf.buildProcessEngine();
    }

    protected DomainHolder<DataSource> getDomainHolder() {
        return (DomainHolder)this.ctx.getBean(DomainHolder.class);
    }

    public void load(String domain) {
        try {
            this.getObject().getEngines().put(domain, this.build((DataSource)this.getDomainHolder().getDomains().get(domain)));
        }
        catch (Exception e) {
            LOG.error("Could not setup Flowable for {}", (Object)domain, (Object)e);
        }
    }

    public DomainProcessEngine getObject() {
        if (this.engine == null) {
            HashMap<String, ProcessEngine> engines = new HashMap<String, ProcessEngine>();
            this.getDomainHolder().getDomains().forEach((domain, datasource) -> engines.put((String)domain, this.build((DataSource)datasource)));
            this.engine = new DomainProcessEngine(engines);
        }
        return this.engine;
    }

    public Class<DomainProcessEngine> getObjectType() {
        return DomainProcessEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @PreDestroy
    public void preDestroy() {
        Optional.ofNullable(this.engine).ifPresent(DomainProcessEngine::close);
    }
}

