/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.NullableStructMessageData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NullableStructMessageTest {
    @Test
    public void testDefaultValues() {
        NullableStructMessageData message = new NullableStructMessageData();
        Assertions.assertNull((Object)message.nullableStruct);
        Assertions.assertEquals((Object)new NullableStructMessageData.MyStruct2(), (Object)message.nullableStruct2);
        Assertions.assertNull((Object)message.nullableStruct3);
        Assertions.assertEquals((Object)new NullableStructMessageData.MyStruct4(), (Object)message.nullableStruct4);
        message = this.roundTrip(message, (short)2);
        Assertions.assertNull((Object)message.nullableStruct);
        Assertions.assertEquals((Object)new NullableStructMessageData.MyStruct2(), (Object)message.nullableStruct2);
        Assertions.assertNull((Object)message.nullableStruct3);
        Assertions.assertEquals((Object)new NullableStructMessageData.MyStruct4(), (Object)message.nullableStruct4);
    }

    @Test
    public void testRoundTrip() {
        NullableStructMessageData message = new NullableStructMessageData().setNullableStruct(new NullableStructMessageData.MyStruct().setMyInt(1).setMyString("1")).setNullableStruct2(new NullableStructMessageData.MyStruct2().setMyInt(2).setMyString("2")).setNullableStruct3(new NullableStructMessageData.MyStruct3().setMyInt(3).setMyString("3")).setNullableStruct4(new NullableStructMessageData.MyStruct4().setMyInt(4).setMyString("4"));
        NullableStructMessageData newMessage = this.roundTrip(message, (short)2);
        Assertions.assertEquals((Object)message, (Object)newMessage);
    }

    @Test
    public void testNullForAllFields() {
        NullableStructMessageData message = new NullableStructMessageData().setNullableStruct(null).setNullableStruct2(null).setNullableStruct3(null).setNullableStruct4(null);
        message = this.roundTrip(message, (short)2);
        Assertions.assertNull((Object)message.nullableStruct);
        Assertions.assertNull((Object)message.nullableStruct2);
        Assertions.assertNull((Object)message.nullableStruct3);
        Assertions.assertNull((Object)message.nullableStruct4);
    }

    @Test
    public void testNullableStruct2CanNotBeNullInVersion0() {
        NullableStructMessageData message = new NullableStructMessageData().setNullableStruct2(null);
        Assertions.assertThrows(NullPointerException.class, () -> this.roundTrip(message, (short)0));
    }

    @Test
    public void testToStringWithNullStructs() {
        NullableStructMessageData message = new NullableStructMessageData().setNullableStruct(null).setNullableStruct2(null).setNullableStruct3(null).setNullableStruct4(null);
        message.toString();
    }

    private NullableStructMessageData deserialize(ByteBuffer buf, short version) {
        NullableStructMessageData message = new NullableStructMessageData();
        message.read((Readable)new ByteBufferAccessor(buf.duplicate()), version);
        return message;
    }

    private ByteBuffer serialize(NullableStructMessageData message, short version) {
        return MessageUtil.toByteBuffer((Message)message, (short)version);
    }

    private NullableStructMessageData roundTrip(NullableStructMessageData message, short version) {
        ByteBuffer buffer = this.serialize(message, version);
        return this.deserialize(buffer.duplicate(), version);
    }
}

