/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.DecorateProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.TitlePatternProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.strategies.AppendingStrategy;
import nz.net.ultraq.thymeleaf.layoutdialect.fragments.CollectFragmentProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.fragments.FragmentProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.includes.IncludeProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.includes.InsertProcessor;
import nz.net.ultraq.thymeleaf.layoutdialect.includes.ReplaceProcessor;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.processor.AbstractProcessor;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.standard.processor.StandardXmlNsTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

public class LayoutDialect
extends AbstractProcessorDialect {
    public static final String DIALECT_NAME = "Layout";
    public static final String DIALECT_PREFIX = "layout";
    public static final int DIALECT_PRECEDENCE = 10;
    private final boolean autoHeadMerging;
    private final SortingStrategy sortingStrategy;

    public LayoutDialect(SortingStrategy sortingStrategy, boolean bl) {
        super(DIALECT_NAME, DIALECT_PREFIX, 10);
        this.sortingStrategy = sortingStrategy;
        this.autoHeadMerging = bl;
    }

    public LayoutDialect(SortingStrategy sortingStrategy) {
        this(sortingStrategy, true);
    }

    public LayoutDialect() {
        this(new AppendingStrategy());
    }

    public Set<IProcessor> getProcessors(String string) {
        return new LinkedHashSet<AbstractProcessor>(Arrays.asList(new AbstractProcessor[]{new StandardXmlNsTagProcessor(TemplateMode.HTML, string), new DecorateProcessor(TemplateMode.HTML, string, this.sortingStrategy, this.autoHeadMerging), new IncludeProcessor(TemplateMode.HTML, string), new InsertProcessor(TemplateMode.HTML, string), new ReplaceProcessor(TemplateMode.HTML, string), new FragmentProcessor(TemplateMode.HTML, string), new CollectFragmentProcessor(TemplateMode.HTML, string), new TitlePatternProcessor(TemplateMode.HTML, string), new StandardXmlNsTagProcessor(TemplateMode.XML, string), new DecorateProcessor(TemplateMode.XML, string, this.sortingStrategy, this.autoHeadMerging), new IncludeProcessor(TemplateMode.XML, string), new InsertProcessor(TemplateMode.XML, string), new ReplaceProcessor(TemplateMode.XML, string), new FragmentProcessor(TemplateMode.XML, string), new CollectFragmentProcessor(TemplateMode.XML, string)}));
    }
}

