/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.datatable.column;

import java.io.Serializable;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.kendo.ui.datatable.column.AbstractColumn;
import org.wicketstuff.kendo.ui.datatable.column.IExportableColumn;
import org.wicketstuff.kendo.ui.utils.PropertyUtils;

public class PropertyColumn
extends AbstractColumn
implements IExportableColumn {
    private static final long serialVersionUID = 1L;
    private final String property;

    public PropertyColumn(String title) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), title, -1);
    }

    public PropertyColumn(String title, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), title, width);
    }

    public PropertyColumn(String title, String property) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), property, -1);
    }

    public PropertyColumn(String title, String property, int width) {
        this((IModel<String>)Model.of((Serializable)((Object)title)), property, width);
    }

    public PropertyColumn(IModel<String> title, String property) {
        this(title, property, -1);
    }

    public PropertyColumn(IModel<String> title, String property, int width) {
        super(title, property, width);
        this.property = property;
    }

    @Override
    public String getField() {
        return PropertyUtils.escape(super.getField());
    }

    public Object getValue(Object object) {
        return PropertyResolver.getValue((String)this.property, (Object)object);
    }

    @Override
    public IModel<Object> newDataModel(IModel<?> rowModel) {
        return new PropertyModel(rowModel, this.property);
    }
}

