/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.rest.SAML2IdPEntityRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.SAML2IdPEntityWizardBuilder;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.ModalPanelBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.SAML2IdPEntityTO;
import org.apache.syncope.common.lib.to.SAML2SPClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class SAML2IdPEntityDirectoryPanel
extends DirectoryPanel<SAML2IdPEntityTO, SAML2IdPEntityTO, SAML2IdPEntityProvider, SAML2IdPEntityRestClient> {
    private static final long serialVersionUID = -6535332920023200166L;
    private final LoadableDetachableModel<List<SAML2SPClientAppTO>> clientApps;
    private final String metadataURL;

    private static ExternalLink metadataLink(String componentId, final String url) {
        return new ExternalLink(componentId, (IModel)Model.of((Serializable)((Object)url)), (IModel)Model.of((Serializable)((Object)url))){
            private static final long serialVersionUID = -1919646533527005367L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.setName("a");
                if (url.startsWith("http")) {
                    tag.put("href", (CharSequence)this.getDefaultModelObject().toString());
                    tag.put("target", (CharSequence)"_blank");
                }
            }
        };
    }

    public SAML2IdPEntityDirectoryPanel(String id, SAML2IdPEntityRestClient restClient, final ClientAppRestClient clientAppRestClient, String waPrefix, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef);
        this.clientApps = new LoadableDetachableModel<List<SAML2SPClientAppTO>>(){
            private static final long serialVersionUID = 7172461137064525667L;

            protected List<SAML2SPClientAppTO> load() {
                return clientAppRestClient.list(ClientAppType.SAML2SP);
            }
        };
        this.metadataURL = waPrefix + "/idp/metadata";
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Large);
        this.modal.addSubmitButton();
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.addNewItemPanelBuilder((ModalPanelBuilder)new SAML2IdPEntityWizardBuilder(new SAML2IdPEntityTO(), restClient, pageRef), false);
        this.initResultTable();
    }

    protected List<IColumn<SAML2IdPEntityTO, String>> getColumns() {
        ArrayList<IColumn<SAML2IdPEntityTO, String>> columns = new ArrayList<IColumn<SAML2IdPEntityTO, String>>();
        columns.add((IColumn<SAML2IdPEntityTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        columns.add((IColumn<SAML2IdPEntityTO, String>)new AbstractColumn<SAML2IdPEntityTO, String>((IModel)Model.of((Serializable)((Object)"URL"))){
            private static final long serialVersionUID = -7226955670801277153L;

            public void populateItem(Item<ICellPopulator<SAML2IdPEntityTO>> cellItem, String componentId, IModel<SAML2IdPEntityTO> rowModel) {
                if ("Syncope".equals(((SAML2IdPEntityTO)rowModel.getObject()).getKey())) {
                    cellItem.add(new Component[]{SAML2IdPEntityDirectoryPanel.metadataLink(componentId, SAML2IdPEntityDirectoryPanel.this.metadataURL)});
                } else {
                    ((List)SAML2IdPEntityDirectoryPanel.this.clientApps.getObject()).stream().filter(app -> ((SAML2IdPEntityTO)rowModel.getObject()).getKey().equals(app.getIdp())).findFirst().ifPresentOrElse(app -> cellItem.add(new Component[]{SAML2IdPEntityDirectoryPanel.metadataLink(componentId, SAML2IdPEntityDirectoryPanel.this.metadataURL + "?service=" + app.getClientAppId())}), () -> cellItem.add(new Component[]{new Label(componentId, (IModel)Model.of())}));
                }
            }
        });
        return columns;
    }

    protected ActionsPanel<SAML2IdPEntityTO> getActions(final IModel<SAML2IdPEntityTO> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<SAML2IdPEntityTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, SAML2IdPEntityTO ignore) {
                SAML2IdPEntityDirectoryPanel.this.send((IEventSink)SAML2IdPEntityDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((SAML2IdPEntityRestClient)SAML2IdPEntityDirectoryPanel.this.restClient).get(((SAML2IdPEntityTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "SAML2_IDP_ENTITY_SET");
        if (!"Syncope".equals(((SAML2IdPEntityTO)model.getObject()).getKey())) {
            panel.add((ActionLink)new ActionLink<SAML2IdPEntityTO>(){
                private static final long serialVersionUID = -3722207913631435501L;

                public void onClick(AjaxRequestTarget target, SAML2IdPEntityTO ignore) {
                    try {
                        ((SAML2IdPEntityRestClient)SAML2IdPEntityDirectoryPanel.this.restClient).delete(((SAML2IdPEntityTO)model.getObject()).getKey());
                        SyncopeConsoleSession.get().success((Serializable)((Object)SAML2IdPEntityDirectoryPanel.this.getString("operation_succeeded")));
                        target.add(new Component[]{SAML2IdPEntityDirectoryPanel.this.container});
                    }
                    catch (SyncopeClientException e) {
                        DirectoryPanel.LOG.error("While deleting IdP {}", (Object)((SAML2IdPEntityTO)model.getObject()).getKey(), (Object)e);
                        SyncopeConsoleSession.get().onException((Exception)((Object)e));
                    }
                    ((BasePage)SAML2IdPEntityDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }, ActionLink.ActionType.DELETE, "SAML2_IDP_ENTITY_DELETE", true);
        }
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected SAML2IdPEntityProvider dataProvider() {
        return new SAML2IdPEntityProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "saml2idpentity.properties.paginator.rows";
    }

    protected final class SAML2IdPEntityProvider
    extends DirectoryDataProvider<SAML2IdPEntityTO> {
        private static final long serialVersionUID = 5282134321828253058L;
        private final SortableDataProviderComparator<SAML2IdPEntityTO> comparator;

        public SAML2IdPEntityProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<? extends SAML2IdPEntityTO> iterator(long first, long count) {
            List<SAML2IdPEntityTO> idps = ((SAML2IdPEntityRestClient)SAML2IdPEntityDirectoryPanel.this.restClient).list();
            idps.sort((Comparator<SAML2IdPEntityTO>)this.comparator);
            return idps.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((SAML2IdPEntityRestClient)SAML2IdPEntityDirectoryPanel.this.restClient).list().size();
        }

        public IModel<SAML2IdPEntityTO> model(SAML2IdPEntityTO metadata) {
            return new CompoundPropertyModel((Object)metadata);
        }
    }
}

