/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.atlas.AtlasCounter;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class AtlasCounterBatchUpdater
implements Counter.BatchUpdater,
Consumer<Supplier<Counter>> {
    private Supplier<Counter> counterSupplier;
    private final int batchSize;
    private int count;
    private double sum;

    AtlasCounterBatchUpdater(int batchSize) {
        this.batchSize = batchSize;
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    public void accept(Supplier<Counter> counterSupplier) {
        this.counterSupplier = counterSupplier;
    }

    private AtlasCounter getCounter() {
        if (this.counterSupplier != null) {
            Counter c = this.counterSupplier.get();
            return c instanceof AtlasCounter ? (AtlasCounter)c : null;
        }
        return null;
    }

    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.sum += amount;
            ++this.count;
            if (this.count >= this.batchSize) {
                this.flush();
            }
        }
    }

    public void flush() {
        AtlasCounter counter = this.getCounter();
        if (counter != null) {
            counter.add(this.sum);
            this.sum = 0.0;
            this.count = 0;
        }
    }

    public void close() throws Exception {
        this.flush();
    }
}

