/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.ipc;

import com.netflix.spectator.ipc.NetflixHeader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public final class NetflixHeaders {
    private static final String[] NETFLIX_ASG = new String[]{"NETFLIX_AUTO_SCALE_GROUP", "CLOUD_AUTO_SCALE_GROUP"};
    private static final String[] NETFLIX_NODE = new String[]{"TITUS_TASK_ID", "EC2_INSTANCE_ID"};
    private static final String[] NETFLIX_ZONE = new String[]{"EC2_AVAILABILITY_ZONE"};

    private NetflixHeaders() {
    }

    private static void addHeader(Map<String, String> headers, Function<String, String> env, NetflixHeader header, String[] names) {
        for (String name : names) {
            String value = env.apply(name);
            if (value == null || value.isEmpty()) continue;
            headers.put(header.headerName(), value);
            break;
        }
    }

    public static Map<String, String> extractFrom(Function<String, String> env) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        NetflixHeaders.addHeader(headers, env, NetflixHeader.ASG, NETFLIX_ASG);
        NetflixHeaders.addHeader(headers, env, NetflixHeader.Node, NETFLIX_NODE);
        NetflixHeaders.addHeader(headers, env, NetflixHeader.Zone, NETFLIX_ZONE);
        return headers;
    }

    public static Map<String, String> extractFromEnvironment() {
        return NetflixHeaders.extractFrom(System::getenv);
    }
}

