/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.hamcrest;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

public final class KafkaMatchers {
    private static final String UNCHECKED = "unchecked";
    private static final String IS_SPACE = "is ";

    private KafkaMatchers() {
    }

    public static <K> Matcher<ConsumerRecord<K, ?>> hasKey(K key) {
        return new ConsumerRecordKeyMatcher<K>(key);
    }

    public static <V> Matcher<ConsumerRecord<?, V>> hasValue(V value) {
        return new ConsumerRecordValueMatcher<V>(value);
    }

    public static Matcher<ConsumerRecord<?, ?>> hasPartition(int partition) {
        return new ConsumerRecordPartitionMatcher(partition);
    }

    public static Matcher<ConsumerRecord<?, ?>> hasTimestamp(long ts) {
        return KafkaMatchers.hasTimestamp(TimestampType.CREATE_TIME, ts);
    }

    public static Matcher<ConsumerRecord<?, ?>> hasTimestamp(TimestampType type, long ts) {
        return new ConsumerRecordTimestampMatcher(type, ts);
    }

    public static class ConsumerRecordKeyMatcher<K>
    extends DiagnosingMatcher<ConsumerRecord<K, ?>> {
        private final K key;

        public ConsumerRecordKeyMatcher(K key) {
            this.key = key;
        }

        public void describeTo(Description description) {
            description.appendText("a ConsumerRecord with key ").appendText(this.key.toString());
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            boolean matches;
            ConsumerRecord record = (ConsumerRecord)item;
            boolean bl = matches = record != null && (record.key() == null && this.key == null || record.key().equals(this.key));
            if (!matches) {
                mismatchDescription.appendText(KafkaMatchers.IS_SPACE).appendValue((Object)record);
            }
            return matches;
        }
    }

    public static class ConsumerRecordValueMatcher<V>
    extends DiagnosingMatcher<ConsumerRecord<?, V>> {
        private final V payload;

        public ConsumerRecordValueMatcher(V payload) {
            this.payload = payload;
        }

        public void describeTo(Description description) {
            description.appendText("a ConsumerRecord with value ").appendText(this.payload.toString());
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            boolean matches;
            ConsumerRecord record = (ConsumerRecord)item;
            boolean bl = matches = record != null && record.value().equals(this.payload);
            if (!matches) {
                mismatchDescription.appendText(KafkaMatchers.IS_SPACE).appendValue((Object)record);
            }
            return matches;
        }
    }

    public static class ConsumerRecordPartitionMatcher
    extends DiagnosingMatcher<ConsumerRecord<?, ?>> {
        private final int partition;

        public ConsumerRecordPartitionMatcher(int partition) {
            this.partition = partition;
        }

        public void describeTo(Description description) {
            description.appendText("a ConsumerRecord with partition ").appendValue((Object)this.partition);
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            boolean matches;
            ConsumerRecord record = (ConsumerRecord)item;
            boolean bl = matches = record != null && record.partition() == this.partition;
            if (!matches) {
                mismatchDescription.appendText(KafkaMatchers.IS_SPACE).appendValue((Object)record);
            }
            return matches;
        }
    }

    public static class ConsumerRecordTimestampMatcher
    extends DiagnosingMatcher<ConsumerRecord<?, ?>> {
        private final TimestampType type;
        private final long ts;

        public ConsumerRecordTimestampMatcher(TimestampType type, long ts) {
            this.type = type;
            this.ts = ts;
        }

        protected boolean matches(Object item, Description mismatchDescription) {
            boolean matches;
            ConsumerRecord record = (ConsumerRecord)item;
            boolean bl = matches = record != null && record.timestampType() == this.type && record.timestamp() == this.ts;
            if (!matches) {
                mismatchDescription.appendText(KafkaMatchers.IS_SPACE).appendValue((Object)record);
            }
            return matches;
        }

        public void describeTo(Description description) {
            description.appendText("a ConsumerRecord with timestamp of type: ").appendValue((Object)this.type).appendText(" and value: ").appendValue((Object)this.ts);
        }
    }
}

