/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.security.auth.sasl.SaslTransportPlugin;
import org.apache.storm.thrift.TProcessor;
import org.apache.storm.thrift.server.TServer;
import org.apache.storm.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftServer {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftServer.class);
    protected final TProcessor processor;
    private final Map<String, Object> conf;
    private final ThriftConnectionType type;
    private TServer server;
    private int port;
    private boolean areWorkerTokensSupported;
    private ITransportPlugin transportPlugin;

    public ThriftServer(Map<String, Object> conf, TProcessor processor, ThriftConnectionType type) {
        this.conf = conf;
        this.processor = processor;
        this.type = type;
        try {
            this.transportPlugin = ClientAuthUtils.getTransportPlugin(this.type, this.conf);
            this.server = this.transportPlugin.getServer(this.processor);
            this.port = this.transportPlugin.getPort();
            this.areWorkerTokensSupported = this.transportPlugin.areWorkerTokensSupported();
        }
        catch (IOException | TTransportException ex) {
            this.handleServerException((Exception)ex);
        }
    }

    public void stop() {
        this.server.stop();
        if (this.transportPlugin instanceof SaslTransportPlugin) {
            ((SaslTransportPlugin)this.transportPlugin).close();
        }
    }

    public boolean isServing() {
        return this.server.isServing();
    }

    public void serve() {
        try {
            this.server.serve();
        }
        catch (Exception ex) {
            this.handleServerException(ex);
        }
    }

    private void handleServerException(Exception ex) {
        LOG.error("ThriftServer is being stopped due to: " + String.valueOf(ex), (Throwable)ex);
        if (this.server != null) {
            this.server.stop();
        }
        Runtime.getRuntime().halt(1);
    }

    public int getPort() {
        return this.port;
    }

    public ThriftConnectionType getType() {
        return this.type;
    }

    public boolean supportsWorkerTokens() {
        return this.areWorkerTokensSupported;
    }

    public Map<String, Object> getConf() {
        return this.conf;
    }

    public TProcessor getProcessor() {
        return this.processor;
    }
}

