/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.isomorphism;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.UniformEquivalenceComparator;
import org.apache.storm.shade.org.jgrapht.experimental.isomorphism.GraphIsomorphismInspector;
import org.apache.storm.shade.org.jgrapht.experimental.isomorphism.GraphOrdering;
import org.apache.storm.shade.org.jgrapht.experimental.isomorphism.IsomorphismRelation;
import org.apache.storm.shade.org.jgrapht.experimental.permutation.CollectionPermutationIter;
import org.apache.storm.shade.org.jgrapht.util.PrefetchIterator;

abstract class AbstractExhaustiveIsomorphismInspector<V, E>
implements GraphIsomorphismInspector<IsomorphismRelation> {
    public static EquivalenceComparator<Object, Object> edgeDefaultIsomorphismComparator = new UniformEquivalenceComparator<Object, Object>();
    public static EquivalenceComparator<Object, Object> vertexDefaultIsomorphismComparator = new UniformEquivalenceComparator<Object, Object>();
    protected EquivalenceComparator<? super E, ? super Graph<V, ? super E>> edgeComparator;
    protected EquivalenceComparator<? super V, ? super Graph<? super V, E>> vertexComparator;
    protected Graph<V, E> graph1;
    protected Graph<V, E> graph2;
    private PrefetchIterator<IsomorphismRelation> nextSupplier;
    private GraphOrdering lableGraph1;
    private LinkedHashSet<V> graph1VertexSet;
    private LinkedHashSet<E> graph2EdgeSet;
    private CollectionPermutationIter<V> vertexPermuteIter;
    private Set<V> currVertexPermutation;

    public AbstractExhaustiveIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2, EquivalenceComparator<? super V, ? super Graph<? super V, ? super E>> vertexChecker, EquivalenceComparator<? super E, ? super Graph<? super V, ? super E>> edgeChecker) {
        this.graph1 = graph1;
        this.graph2 = graph2;
        this.vertexComparator = vertexChecker != null ? vertexChecker : vertexDefaultIsomorphismComparator;
        if (edgeChecker != null) {
            this.edgeComparator = edgeChecker;
        }
        this.init();
    }

    public AbstractExhaustiveIsomorphismInspector(Graph<V, E> graph1, Graph<V, E> graph2) {
        this(graph1, graph2, edgeDefaultIsomorphismComparator, vertexDefaultIsomorphismComparator);
    }

    private void init() {
        this.nextSupplier = new PrefetchIterator<IsomorphismRelation>(new NextFunctor());
        this.graph1VertexSet = new LinkedHashSet<V>(this.graph1.vertexSet());
        this.vertexPermuteIter = this.createPermutationIterator(this.graph1VertexSet, this.graph2.vertexSet());
        this.lableGraph1 = new GraphOrdering<V, E>(this.graph1, this.graph1VertexSet, this.graph1.edgeSet());
        this.graph2EdgeSet = new LinkedHashSet<E>(this.graph2.edgeSet());
    }

    protected abstract CollectionPermutationIter<V> createPermutationIterator(Set<V> var1, Set<V> var2);

    private IsomorphismRelation<V, E> findNextIsomorphicGraph() {
        boolean result = false;
        IsomorphismRelation<V, E> resultRelation = null;
        if (this.vertexPermuteIter != null) {
            while (this.vertexPermuteIter.hasNext()) {
                boolean edgeEq;
                GraphOrdering<V, E> currPermuteGraph;
                this.currVertexPermutation = this.vertexPermuteIter.getNextSet();
                if (!this.areVertexSetsOfTheSameEqualityGroup(this.graph1VertexSet, this.currVertexPermutation) || !this.lableGraph1.equalsByEdgeOrder(currPermuteGraph = new GraphOrdering<V, E>(this.graph2, this.currVertexPermutation, this.graph2EdgeSet)) || !(edgeEq = this.areAllEdgesEquivalent(resultRelation = new IsomorphismRelation<V, E>(new ArrayList<V>(this.graph1VertexSet), new ArrayList<V>(this.currVertexPermutation), this.graph1, this.graph2), this.edgeComparator))) continue;
                result = true;
                break;
            }
        }
        if (result) {
            return resultRelation;
        }
        return null;
    }

    protected abstract boolean areVertexSetsOfTheSameEqualityGroup(Set<V> var1, Set<V> var2);

    protected boolean areAllEdgesEquivalent(IsomorphismRelation<V, E> resultRelation, EquivalenceComparator<? super E, ? super Graph<V, E>> edgeComparator) {
        boolean checkResult = true;
        if (edgeComparator == null) {
            return true;
        }
        try {
            Set<E> edgeSet = this.graph1.edgeSet();
            for (E currEdge : edgeSet) {
                E correspondingEdge;
                if (edgeComparator.equivalenceCompare(currEdge, correspondingEdge = resultRelation.getEdgeCorrespondence(currEdge, true), this.graph1, this.graph2)) continue;
                checkResult = false;
                break;
            }
        }
        catch (IllegalArgumentException illegal) {
            checkResult = false;
        }
        return checkResult;
    }

    public IsomorphismRelation nextIsoRelation() {
        return this.next();
    }

    @Override
    public boolean isIsomorphic() {
        return !this.nextSupplier.isEnumerationStartedEmpty();
    }

    @Override
    public boolean hasNext() {
        boolean result = this.nextSupplier.hasMoreElements();
        return result;
    }

    @Override
    public IsomorphismRelation next() {
        return this.nextSupplier.nextElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported in AdaptiveIsomorphismInspectorFactory. There is no meaning to removing an isomorphism result.");
    }

    private class NextFunctor
    implements PrefetchIterator.NextElementFunctor<IsomorphismRelation> {
        private NextFunctor() {
        }

        @Override
        public IsomorphismRelation nextElement() throws NoSuchElementException {
            IsomorphismRelation resultRelation = AbstractExhaustiveIsomorphismInspector.this.findNextIsomorphicGraph();
            if (resultRelation != null) {
                return resultRelation;
            }
            throw new NoSuchElementException("IsomorphismInspector does not have any more elements");
        }
    }
}

