/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jctools.queues.unpadded;

import org.apache.storm.shade.org.jctools.queues.LinkedArrayQueueUtil;
import org.apache.storm.shade.org.jctools.queues.unpadded.MpscChunkedUnpaddedArrayQueueColdProducerFields;
import org.apache.storm.shade.org.jctools.util.Pow2;

public class MpscChunkedUnpaddedArrayQueue<E>
extends MpscChunkedUnpaddedArrayQueueColdProducerFields<E> {
    public MpscChunkedUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Math.min(1024, Pow2.roundToPowerOfTwo(maxCapacity / 8))), maxCapacity);
    }

    public MpscChunkedUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected long availableInQueue(long pIndex, long cIndex) {
        return this.maxQueueCapacity - (pIndex - cIndex);
    }

    @Override
    public int capacity() {
        return (int)(this.maxQueueCapacity / 2L);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        return LinkedArrayQueueUtil.length(buffer);
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask;
    }
}

