/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.curator.framework.recipes.queue;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueAllocator;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.storm.shade.org.apache.curator.framework.recipes.queue.QueueSharderPolicies;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.ImmutableSet;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.storm.shade.org.apache.curator.shaded.com.google.common.collect.Sets;
import org.apache.storm.shade.org.apache.curator.utils.CloseableUtils;
import org.apache.storm.shade.org.apache.curator.utils.ThreadUtils;
import org.apache.storm.shade.org.apache.curator.utils.ZKPaths;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueSharder<U, T extends QueueBase<U>>
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final QueueAllocator<U, T> queueAllocator;
    private final String queuePath;
    private final QueueSharderPolicies policies;
    private final ConcurrentMap<String, T> queues = Maps.newConcurrentMap();
    private final Set<String> preferredQueues = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final LeaderLatch leaderLatch;
    private final ExecutorService service;
    private static final String QUEUE_PREFIX = "queue-";

    public QueueSharder(CuratorFramework client, QueueAllocator<U, T> queueAllocator, String queuePath, String leaderPath, QueueSharderPolicies policies) {
        this.client = client;
        this.queueAllocator = queueAllocator;
        this.queuePath = queuePath;
        this.policies = policies;
        this.leaderLatch = new LeaderLatch(client, leaderPath);
        this.service = Executors.newSingleThreadExecutor(policies.getThreadFactory());
    }

    public void start() throws Exception {
        Preconditions.checkState(this.state.compareAndSet(State.LATENT, State.STARTED), "Cannot be started more than once");
        this.client.createContainers(this.queuePath);
        this.getInitialQueues();
        this.leaderLatch.start();
        this.service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (QueueSharder.this.state.get() == State.STARTED) {
                    try {
                        Thread.sleep(QueueSharder.this.policies.getThresholdCheckMs());
                        QueueSharder.this.checkThreshold();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return null;
            }
        });
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.service.shutdownNow();
            CloseableUtils.closeQuietly(this.leaderLatch);
            for (QueueBase queue : this.queues.values()) {
                try {
                    queue.close();
                }
                catch (IOException e) {
                    this.log.error("Closing a queue", (Throwable)e);
                }
            }
        }
    }

    public T getQueue() {
        Preconditions.checkState(this.state.get() == State.STARTED, "Not started");
        ArrayList<String> localPreferredQueues = Lists.newArrayList(this.preferredQueues);
        if (localPreferredQueues.size() > 0) {
            String key = (String)localPreferredQueues.get(ThreadLocalRandom.current().nextInt(localPreferredQueues.size()));
            return (T)((QueueBase)this.queues.get(key));
        }
        ArrayList keys = Lists.newArrayList(this.queues.keySet());
        String key = (String)keys.get(ThreadLocalRandom.current().nextInt(keys.size()));
        return (T)((QueueBase)this.queues.get(key));
    }

    public int getShardQty() {
        return this.queues.size();
    }

    public Collection<String> getQueuePaths() {
        return ImmutableSet.copyOf(this.queues.keySet());
    }

    private void getInitialQueues() throws Exception {
        List children = (List)this.client.getChildren().forPath(this.queuePath);
        for (String child : children) {
            String queuePath = ZKPaths.makePath(this.queuePath, child);
            this.addNewQueueIfNeeded(queuePath);
        }
        if (children.size() == 0) {
            this.addNewQueueIfNeeded(null);
        }
    }

    private void addNewQueueIfNeeded(String newQueuePath) throws Exception {
        T queue;
        if (newQueuePath == null) {
            newQueuePath = ZKPaths.makePath(this.queuePath, QUEUE_PREFIX + UUID.randomUUID().toString());
        }
        if (!this.queues.containsKey(newQueuePath) && this.queues.putIfAbsent(newQueuePath, queue = this.queueAllocator.allocateQueue(this.client, newQueuePath)) == null) {
            queue.start();
            this.preferredQueues.add(newQueuePath);
        }
    }

    private void checkThreshold() {
        try {
            boolean addAQueueIfLeader = false;
            int size = 0;
            List children = (List)this.client.getChildren().forPath(this.queuePath);
            for (String child : children) {
                String queuePath = ZKPaths.makePath(this.queuePath, child);
                this.addNewQueueIfNeeded(queuePath);
                Stat stat = (Stat)this.client.checkExists().forPath(queuePath);
                if (stat.getNumChildren() >= this.policies.getNewQueueThreshold()) {
                    size = stat.getNumChildren();
                    addAQueueIfLeader = true;
                    this.preferredQueues.remove(queuePath);
                    continue;
                }
                if (stat.getNumChildren() > this.policies.getNewQueueThreshold() / 2) continue;
                this.preferredQueues.add(queuePath);
            }
            if (addAQueueIfLeader && this.leaderLatch.hasLeadership()) {
                if (this.queues.size() < this.policies.getMaxQueues()) {
                    this.log.info(String.format("Adding a queue due to exceeded threshold. Queue Size: %d - Threshold: %d", size, this.policies.getNewQueueThreshold()));
                    this.addNewQueueIfNeeded(null);
                } else {
                    this.log.warn(String.format("Max number of queues (%d) reached. Consider increasing the max.", this.policies.getMaxQueues()));
                }
            }
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted(e);
            this.log.error("Checking queue counts against threshold", (Throwable)e);
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

