/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.channel.socket.DatagramPacket;
import org.apache.storm.shade.io.netty.channel.unix.Buffer;
import org.apache.storm.shade.io.netty.channel.uring.IoUringDatagramChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUringIoHandler;
import org.apache.storm.shade.io.netty.channel.uring.Iov;
import org.apache.storm.shade.io.netty.channel.uring.LinuxSocket;
import org.apache.storm.shade.io.netty.channel.uring.MsgHdr;
import org.apache.storm.shade.io.netty.channel.uring.Native;
import org.apache.storm.shade.io.netty.channel.uring.SockaddrIn;

final class MsgHdrMemory {
    private static final byte[] EMPTY_SOCKADDR_STORAGE = new byte[Native.SIZEOF_SOCKADDR_STORAGE];
    private final ByteBuffer msgHdrMemory;
    private final ByteBuffer socketAddrMemory;
    private final ByteBuffer iovMemory;
    private final ByteBuffer cmsgDataMemory;
    private final long msgHdrMemoryAddress;
    private final short idx;
    private final int cmsgDataOffset;

    MsgHdrMemory(short idx) {
        this.idx = idx;
        this.msgHdrMemory = Buffer.allocateDirectWithNativeOrder(Native.SIZEOF_MSGHDR);
        this.msgHdrMemoryAddress = Buffer.memoryAddress(this.msgHdrMemory);
        this.socketAddrMemory = Buffer.allocateDirectWithNativeOrder(Native.SIZEOF_SOCKADDR_STORAGE);
        this.iovMemory = Buffer.allocateDirectWithNativeOrder(Native.SIZEOF_IOVEC);
        this.cmsgDataMemory = Buffer.allocateDirectWithNativeOrder(Native.CMSG_SPACE);
        long cmsgDataMemoryAddr = Buffer.memoryAddress(this.cmsgDataMemory);
        long cmsgDataAddr = Native.cmsghdrData(cmsgDataMemoryAddr);
        this.cmsgDataOffset = (int)(cmsgDataAddr + cmsgDataMemoryAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(LinuxSocket socket, InetSocketAddress address, long bufferAddress, int length, short segmentSize) {
        int addressLength;
        if (address == null) {
            addressLength = socket.isIpv6() ? Native.SIZEOF_SOCKADDR_IN6 : Native.SIZEOF_SOCKADDR_IN;
            this.socketAddrMemory.mark();
            try {
                this.socketAddrMemory.put(EMPTY_SOCKADDR_STORAGE);
            }
            finally {
                this.socketAddrMemory.reset();
            }
        } else {
            addressLength = SockaddrIn.set(socket.isIpv6(), this.socketAddrMemory, address);
        }
        Iov.set(this.iovMemory, bufferAddress, length);
        MsgHdr.set(this.msgHdrMemory, this.socketAddrMemory, addressLength, this.iovMemory, 1, this.cmsgDataMemory, this.cmsgDataOffset, segmentSize);
    }

    boolean hasPort(IoUringDatagramChannel channel) {
        if (channel.socket.isIpv6()) {
            return SockaddrIn.hasPortIpv6(this.socketAddrMemory);
        }
        return SockaddrIn.hasPortIpv4(this.socketAddrMemory);
    }

    DatagramPacket get(IoUringDatagramChannel channel, IoUringIoHandler handler, ByteBuf buffer, int bytesRead) {
        InetSocketAddress sender;
        if (channel.socket.isIpv6()) {
            byte[] ipv6Bytes = handler.inet6AddressArray();
            byte[] ipv4bytes = handler.inet4AddressArray();
            sender = SockaddrIn.getIPv6(this.socketAddrMemory, ipv6Bytes, ipv4bytes);
        } else {
            byte[] bytes = handler.inet4AddressArray();
            sender = SockaddrIn.getIPv4(this.socketAddrMemory, bytes);
        }
        long bufferAddress = Iov.getBufferAddress(this.iovMemory);
        int bufferLength = Iov.getBufferLength(this.iovMemory);
        int readerIndex = (int)(bufferAddress - buffer.memoryAddress());
        ByteBuf slice = buffer.slice(readerIndex, bufferLength).writerIndex(bytesRead);
        return new DatagramPacket(slice.retain(), channel.localAddress(), sender);
    }

    short idx() {
        return this.idx;
    }

    long address() {
        return this.msgHdrMemoryAddress;
    }

    void release() {
        Buffer.free(this.msgHdrMemory);
        Buffer.free(this.socketAddrMemory);
        Buffer.free(this.iovMemory);
        Buffer.free(this.cmsgDataMemory);
    }
}

