/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.nio.ByteBuffer;
import org.apache.storm.shade.io.netty.channel.uring.Native;

final class CmsgHdr {
    private CmsgHdr() {
    }

    static void write(ByteBuffer cmsghdr, int cmsgHdrDataOffset, int cmsgLen, int cmsgLevel, int cmsgType, short segmentSize) {
        int cmsghdrPosition = cmsghdr.position();
        if (Native.SIZEOF_SIZE_T == 4) {
            cmsghdr.putInt(cmsghdrPosition + Native.CMSG_OFFSETOF_CMSG_LEN, cmsgLen);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            cmsghdr.putLong(cmsghdrPosition + Native.CMSG_OFFSETOF_CMSG_LEN, cmsgLen);
        }
        cmsghdr.putInt(cmsghdrPosition + Native.CMSG_OFFSETOF_CMSG_LEVEL, cmsgLevel);
        cmsghdr.putInt(cmsghdrPosition + Native.CMSG_OFFSETOF_CMSG_TYPE, cmsgType);
        cmsghdr.putShort(cmsghdrPosition + cmsgHdrDataOffset, segmentSize);
    }
}

