/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import io.dropwizard.jersey.errors.ErrorMessage;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import org.slf4j.LoggerFactory;

@Provider
public class JsonProcessingExceptionMapper
extends LoggingExceptionMapper<JsonProcessingException> {
    private final boolean showDetails;

    public JsonProcessingExceptionMapper() {
        this(false);
    }

    public JsonProcessingExceptionMapper(boolean showDetails) {
        super(LoggerFactory.getLogger(JsonProcessingExceptionMapper.class));
        this.showDetails = showDetails;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    @Override
    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException || exception instanceof InvalidDefinitionException) {
            return super.toResponse(exception);
        }
        this.logger.debug("Unable to process JSON", (Throwable)exception);
        String message = exception.getOriginalMessage();
        ErrorMessage errorMessage = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process JSON", this.showDetails ? message : null);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorMessage).build();
    }
}

