/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.gzip;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

@Provider
@Priority(value=4000)
public class GZipDecoder
implements ReaderInterceptor {
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException {
        String contentEncoding;
        if (!context.getHeaders().containsKey((Object)"Accept-Encoding")) {
            context.getHeaders().add((Object)"Accept-Encoding", (Object)"gzip");
        }
        if ((contentEncoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding")) != null && (contentEncoding.equals("gzip") || contentEncoding.equals("x-gzip"))) {
            context.setInputStream((InputStream)new GZIPInputStream(context.getInputStream()));
        }
        return context.proceed();
    }
}

