/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.caching;

import io.dropwizard.jersey.caching.CacheControl;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.glassfish.jersey.server.model.AnnotatedMethod;

@Provider
public class CacheControlledResponseFeature
implements DynamicFeature {
    private static final String STALE_WHILE_REVALIDATE = "stale-while-revalidate";

    public void configure(ResourceInfo resourceInfo, FeatureContext configuration) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        CacheControl cc = (CacheControl)am.getAnnotation(CacheControl.class);
        if (cc != null) {
            configuration.register((Object)new CacheControlledResponseFilter(cc));
        }
    }

    private static class CacheControlledResponseFilter
    implements ContainerResponseFilter {
        private static final int ONE_YEAR_IN_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L);
        private String cacheResponseHeader;

        CacheControlledResponseFilter(CacheControl control) {
            jakarta.ws.rs.core.CacheControl cacheControl = new jakarta.ws.rs.core.CacheControl();
            cacheControl.setPrivate(control.isPrivate());
            cacheControl.setNoCache(control.noCache());
            cacheControl.setNoStore(control.noStore());
            cacheControl.setNoTransform(control.noTransform());
            cacheControl.setMustRevalidate(control.mustRevalidate());
            cacheControl.setProxyRevalidate(control.proxyRevalidate());
            cacheControl.setMaxAge((int)control.maxAgeUnit().toSeconds(control.maxAge()));
            cacheControl.setSMaxAge((int)control.sharedMaxAgeUnit().toSeconds(control.sharedMaxAge()));
            if (control.immutable()) {
                cacheControl.setMaxAge(ONE_YEAR_IN_SECONDS);
            }
            if (control.staleWhileRevalidate() > -1) {
                cacheControl.getCacheExtension().put(CacheControlledResponseFeature.STALE_WHILE_REVALIDATE, Long.toString(control.staleWhileRevalidateUnit().toSeconds(control.staleWhileRevalidate())));
            }
            this.cacheResponseHeader = cacheControl.toString();
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            if (!this.cacheResponseHeader.isEmpty()) {
                responseContext.getHeaders().add((Object)"Cache-Control", (Object)this.cacheResponseHeader);
            }
        }
    }
}

