/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.streams.functions;

import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.streams.operations.Function;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationFunction
implements Function<Values, Values> {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationFunction.class);
    private final ExecutableExpression projectionInstance;
    private final Object[] outputValues;
    private final DataContext dataContext;

    public EvaluationFunction(ExecutableExpression projectionInstance, int outputCount, DataContext dataContext) {
        this.projectionInstance = projectionInstance;
        this.outputValues = new Object[outputCount];
        this.dataContext = dataContext;
        if (projectionInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code: {}", (Object)((DebuggableExecutableExpression)projectionInstance).getDelegateCode());
        }
    }

    public Values apply(Values input) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = input.toArray();
        this.projectionInstance.execute(calciteContext, this.outputValues);
        return new Values(this.outputValues);
    }
}

