/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.storm.spout.Scheme;
import org.apache.storm.sql.runtime.serde.avro.CachedSchemas;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class AvroScheme
implements Scheme {
    private final String schemaString;
    private final List<String> fieldNames;
    private final CachedSchemas schemas;

    public AvroScheme(String schemaString, List<String> fieldNames) {
        this.schemaString = schemaString;
        this.fieldNames = fieldNames;
        this.schemas = new CachedSchemas();
    }

    public List<Object> deserialize(ByteBuffer ser) {
        try {
            Schema schema = this.schemas.getSchema(this.schemaString);
            GenericDatumReader reader = new GenericDatumReader(schema);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(Utils.toByteArray((ByteBuffer)ser), null);
            GenericRecord record = (GenericRecord)reader.read(null, (Decoder)decoder);
            ArrayList<Object> list = new ArrayList<Object>(this.fieldNames.size());
            for (String field : this.fieldNames) {
                Object value = record.get(field);
                list.add(SerdeUtils.convertAvroUtf8(value));
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Fields getOutputFields() {
        return new Fields(this.fieldNames);
    }
}

