/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.datasource.socket.bolt;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.storm.shade.org.apache.commons.io.IOUtils;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(SocketBolt.class);
    private final IOutputSerializer serializer;
    private final String host;
    private final int port;
    private transient OutputCollector collector;
    private transient BufferedWriter writer;
    private transient Socket socket;

    public SocketBolt(IOutputSerializer serializer, String host, int port) {
        this.serializer = serializer;
        this.host = host;
        this.port = port;
    }

    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        try {
            this.socket = new Socket(this.host, this.port);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while initializing socket for State. host " + this.host + " port " + this.port, e);
        }
    }

    public void execute(Tuple input) {
        Values values = (Values)input.getValue(0);
        byte[] array = this.serializer.write((List<Object>)values, null).array();
        String data = new String(array);
        try {
            this.writer.write(data + "\n");
            this.writer.flush();
            this.collector.ack(input);
        }
        catch (IOException e) {
            LOG.error("Error while writing data to socket.", (Throwable)e);
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
    }

    public void cleanup() {
        IOUtils.closeQuietly((Writer)this.writer);
        IOUtils.closeQuietly((Socket)this.socket);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

