/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.logviewer.utils;

import com.codahale.metrics.Meter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.storm.daemon.logviewer.utils.DirectoryCleaner;
import org.apache.storm.daemon.supervisor.ClientSupervisorUtils;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.daemon.utils.PathUtil;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.LruMap;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerConfigUtils;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerLogs {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerLogs.class);
    public static final String WORKER_YAML = "worker.yaml";
    private final Meter numSetPermissionsExceptions;
    private final Map<String, Object> stormConf;
    private final Path logRootDir;
    private final DirectoryCleaner directoryCleaner;
    private final LruMap<String, Integer> mapTopologyIdToHeartbeatTimeout;

    public WorkerLogs(Map<String, Object> stormConf, Path logRootDir, StormMetricsRegistry metricsRegistry) {
        this.stormConf = stormConf;
        this.logRootDir = logRootDir.toAbsolutePath().normalize();
        this.numSetPermissionsExceptions = metricsRegistry.registerMeter("logviewer:num-set-permission-exceptions");
        this.directoryCleaner = new DirectoryCleaner(metricsRegistry);
        this.mapTopologyIdToHeartbeatTimeout = new LruMap(200);
    }

    public void setLogFilePermission(String fileName) throws IOException {
        Optional topoOwner;
        Path absFile = this.logRootDir.resolve(fileName).toAbsolutePath().normalize();
        if (!absFile.startsWith(this.logRootDir)) {
            return;
        }
        boolean runAsUser = ObjectReader.getBoolean((Object)this.stormConf.get("supervisor.run.worker.as.user"), (boolean)false);
        Path parent = this.logRootDir.resolve(fileName).getParent();
        Optional mdFile = parent == null ? Optional.empty() : this.getMetadataFileForWorkerLogDir(parent);
        Optional<Object> optional = topoOwner = mdFile.isPresent() ? Optional.of(this.getTopologyOwnerFromMetadataFile(((Path)mdFile.get()).toAbsolutePath().normalize())) : Optional.empty();
        if (runAsUser && topoOwner.isPresent() && absFile.toFile().exists() && !Files.isReadable(absFile)) {
            LOG.debug("Setting permissions on file {} with topo-owner {}", (Object)fileName, topoOwner);
            try {
                ClientSupervisorUtils.processLauncherAndWait(this.stormConf, (String)((String)topoOwner.get()), (List)Lists.newArrayList((Object[])new String[]{"blob", absFile.toAbsolutePath().normalize().toString()}), null, (String)("setup group read permissions for file: " + fileName));
            }
            catch (IOException e) {
                this.numSetPermissionsExceptions.mark();
                throw e;
            }
        }
    }

    public List<Path> getAllLogsForRootDir() throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        Set<Path> topoDirFiles = this.getAllWorkerDirs();
        if (topoDirFiles != null) {
            for (Path portDir : topoDirFiles) {
                files.addAll(this.directoryCleaner.getFilesForDir(portDir));
            }
        }
        return files;
    }

    public Set<Path> getAllWorkerDirs() {
        Set set;
        block8: {
            Stream<Path> topoDirs = Files.list(this.logRootDir);
            try {
                set = topoDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(a -> {
                    try {
                        return Files.list(a);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toCollection(TreeSet::new));
                if (topoDirs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (topoDirs != null) {
                        try {
                            topoDirs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Utils.wrapInRuntime((Exception)e);
                }
            }
            topoDirs.close();
        }
        return set;
    }

    public SortedSet<Path> getAliveWorkerDirs() throws IOException {
        Set<String> aliveIds = this.getAliveIds(Time.currentTimeSecs());
        Set<Path> logDirs = this.getAllWorkerDirs();
        return this.getLogDirs(logDirs, wid -> aliveIds.contains(wid));
    }

    public Optional<Path> getMetadataFileForWorkerLogDir(Path logDir) throws IOException {
        Path metaFile = logDir.resolve(WORKER_YAML);
        if (metaFile.toFile().exists()) {
            return Optional.of(metaFile);
        }
        LOG.warn("Could not find {} to clean up for {}", (Object)metaFile.toAbsolutePath().normalize(), (Object)logDir);
        return Optional.empty();
    }

    public String getWorkerIdFromMetadataFile(Path metaFile) {
        Map map = (Map)Utils.readYamlFile((String)metaFile.toString());
        return ObjectReader.getString(map == null ? null : map.get("worker-id"), null);
    }

    public String getTopologyOwnerFromMetadataFile(Path metaFile) {
        Map map = (Map)Utils.readYamlFile((String)metaFile.toString());
        return ObjectReader.getString(map.get("topology.submitter.user"), null);
    }

    public Set<String> getAliveIds(int nowSecs) throws IOException {
        return SupervisorUtils.readWorkerHeartbeats(this.stormConf).entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue()) && !this.isTimedOut(nowSecs, (Map.Entry<String, LSWorkerHeartbeat>)entry)).map(Map.Entry::getKey).collect(Collectors.toCollection(TreeSet::new));
    }

    private boolean isTimedOut(int nowSecs, Map.Entry<String, LSWorkerHeartbeat> entry) {
        LSWorkerHeartbeat hb = entry.getValue();
        int workerLogTimeout = this.getTopologyTimeout(hb);
        return nowSecs - hb.get_time_secs() >= workerLogTimeout;
    }

    private int getTopologyTimeout(LSWorkerHeartbeat hb) {
        String topoId = hb.get_topology_id();
        Integer cachedTimeout = (Integer)this.mapTopologyIdToHeartbeatTimeout.get((Object)topoId);
        if (cachedTimeout != null) {
            return cachedTimeout;
        }
        int timeout = this.getWorkerLogTimeout(this.stormConf, topoId, hb.get_port());
        this.mapTopologyIdToHeartbeatTimeout.put((Object)topoId, (Object)timeout);
        return timeout;
    }

    private int getWorkerLogTimeout(Map<String, Object> conf, String topologyId, int port) {
        int defaultWorkerLogTimeout = ObjectReader.getInt((Object)conf.get("supervisor.worker.timeout.secs"));
        File file = ServerConfigUtils.getLogMetaDataFile(conf, (String)topologyId, (Integer)port);
        Map map = (Map)Utils.readYamlFile((String)file.getAbsolutePath());
        if (map == null) {
            return defaultWorkerLogTimeout;
        }
        return map.getOrDefault("topology.worker.timeout.secs", defaultWorkerLogTimeout);
    }

    public SortedSet<Path> getLogDirs(Set<Path> logDirs, Predicate<String> predicate) {
        TreeSet<Path> ret = new TreeSet<Path>();
        for (Path logDir : logDirs) {
            String workerId = "";
            try {
                Optional<Path> metaFile = this.getMetadataFileForWorkerLogDir(logDir);
                if (metaFile.isPresent() && (workerId = this.getWorkerIdFromMetadataFile(metaFile.get().toAbsolutePath().normalize())) == null) {
                    workerId = "";
                }
            }
            catch (IOException e) {
                LOG.warn("Error trying to find worker.yaml in {}", (Object)logDir, (Object)e);
            }
            if (!predicate.test(workerId)) continue;
            ret.add(logDir);
        }
        return ret;
    }

    public static String getTopologyPortWorkerLog(Path file) {
        return PathUtil.truncatePathToLastElements(file.toAbsolutePath().normalize(), 3).toString();
    }
}

