/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.schema.CustomColumnResolvingTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.FieldNamespace;
import org.apache.calcite.sql.validate.MatchRecognizeScope;
import org.apache.calcite.sql.validate.SchemaNamespace;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public abstract class DelegatingScope
implements SqlValidatorScope {
    protected final SqlValidatorScope parent;
    protected final SqlValidatorImpl validator;

    DelegatingScope(SqlValidatorScope parent) {
        assert (parent != null);
        this.validator = (SqlValidatorImpl)parent.getValidator();
        this.parent = parent;
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias, boolean nullable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolve(List<String> names, SqlNameMatcher nameMatcher, boolean deep, SqlValidatorScope.Resolved resolved) {
        this.parent.resolve(names, nameMatcher, deep, resolved);
    }

    void resolveInNamespace(SqlValidatorNamespace ns, boolean nullable, List<String> names, SqlNameMatcher nameMatcher, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        if (names.isEmpty()) {
            resolved.found(ns, nullable, this, path, null);
            return;
        }
        RelDataType rowType = ns.getRowType();
        if (rowType.isStruct()) {
            Table t;
            SqlValidatorTable validatorTable = ns.getTable();
            if (validatorTable instanceof Prepare.PreparingTable && (t = ((Prepare.PreparingTable)validatorTable).unwrap(Table.class)) instanceof CustomColumnResolvingTable) {
                List<Pair<RelDataTypeField, List<String>>> entries = ((CustomColumnResolvingTable)t).resolveColumn(rowType, this.validator.getTypeFactory(), names);
                for (Pair<RelDataTypeField, List<String>> entry : entries) {
                    RelDataTypeField field = entry.getKey();
                    List<String> remainder = entry.getValue();
                    FieldNamespace ns2 = new FieldNamespace(this.validator, field.getType());
                    SqlValidatorScope.Step path2 = path.plus(rowType, field.getIndex(), field.getName(), StructKind.FULLY_QUALIFIED);
                    this.resolveInNamespace(ns2, nullable, remainder, nameMatcher, path2, resolved);
                }
                return;
            }
            String name = names.get(0);
            RelDataTypeField field0 = nameMatcher.field(rowType, name);
            if (field0 != null) {
                SqlValidatorNamespace ns2 = ns.lookupChild(field0.getName());
                SqlValidatorScope.Step path2 = path.plus(rowType, field0.getIndex(), field0.getName(), StructKind.FULLY_QUALIFIED);
                this.resolveInNamespace(ns2, nullable, names.subList(1, names.size()), nameMatcher, path2, resolved);
            } else {
                for (RelDataTypeField field : rowType.getFieldList()) {
                    switch (field.getType().getStructKind()) {
                        case PEEK_FIELDS: 
                        case PEEK_FIELDS_DEFAULT: 
                        case PEEK_FIELDS_NO_EXPAND: {
                            SqlValidatorScope.Step path2 = path.plus(rowType, field.getIndex(), field.getName(), field.getType().getStructKind());
                            SqlValidatorNamespace ns2 = ns.lookupChild(field.getName());
                            this.resolveInNamespace(ns2, nullable, names, nameMatcher, path2, resolved);
                        }
                    }
                }
            }
        }
    }

    protected void addColumnNames(SqlValidatorNamespace ns, List<SqlMoniker> colNames) {
        RelDataType rowType;
        try {
            rowType = ns.getRowType();
        }
        catch (Error e) {
            return;
        }
        for (RelDataTypeField field : rowType.getFieldList()) {
            colNames.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
        }
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        return this.parent.findQualifyingTableName(columnName, ctx);
    }

    @Override
    public Map<String, ScopeChild> findQualifyingTableNames(String columnName, SqlNode ctx, SqlNameMatcher nameMatcher) {
        return this.parent.findQualifyingTableNames(columnName, ctx, nameMatcher);
    }

    @Override
    public RelDataType resolveColumn(String name, SqlNode ctx) {
        return this.parent.resolveColumn(name, ctx);
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        return this.parent.nullifyType(node, type);
    }

    @Override
    public SqlValidatorNamespace getTableNamespace(List<String> names) {
        return this.parent.getTableNamespace(names);
    }

    @Override
    public void resolveTable(List<String> names, SqlNameMatcher nameMatcher, SqlValidatorScope.Path path, SqlValidatorScope.Resolved resolved) {
        this.parent.resolveTable(names, nameMatcher, path, resolved);
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call instanceof SqlSelect) {
            return this.validator.getSelectScope((SqlSelect)call);
        }
        return this;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public SqlQualified fullyQualify(SqlIdentifier identifier) {
        SqlValidatorScope.Path path;
        Object alias;
        int i;
        String columnName;
        if (identifier.isStar()) {
            return SqlQualified.create(this, 1, null, identifier);
        }
        SqlIdentifier previous = identifier;
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        switch (identifier.names.size()) {
            case 1: {
                SqlValidatorNamespace namespace;
                String tableName;
                columnName = (String)identifier.names.get(0);
                Map<String, ScopeChild> map = this.findQualifyingTableNames(columnName, identifier, nameMatcher);
                switch (map.size()) {
                    case 0: {
                        SqlNameMatcher liberalMatcher;
                        Map<String, ScopeChild> map2;
                        if (nameMatcher.isCaseSensitive() && !(map2 = this.findQualifyingTableNames(columnName, identifier, liberalMatcher = SqlNameMatchers.liberal())).isEmpty()) {
                            ArrayList<String> list = new ArrayList<String>();
                            for (ScopeChild entry : map2.values()) {
                                RelDataTypeField field = liberalMatcher.field(entry.namespace.getRowType(), columnName);
                                list.add(field.getName());
                            }
                            Collections.sort(list);
                            throw this.validator.newValidationError(identifier, Static.RESOURCE.columnNotFoundDidYouMean(columnName, Util.sepList(list, "', '")));
                        }
                        throw this.validator.newValidationError(identifier, Static.RESOURCE.columnNotFound(columnName));
                    }
                    case 1: {
                        tableName = map.keySet().iterator().next();
                        namespace = map.get((Object)tableName).namespace;
                        break;
                    }
                    default: {
                        throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
                    }
                }
                SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                this.resolveInNamespace(namespace, false, (List<String>)identifier.names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
                RelDataTypeField field = nameMatcher.field(namespace.getRowType(), columnName);
                if (field != null) {
                    if (this.hasAmbiguousUnresolvedStar(namespace.getRowType(), field, columnName)) {
                        throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(columnName));
                    }
                    columnName = field.getName();
                }
                SqlParserPos pos = identifier.getParserPosition();
                identifier = new SqlIdentifier((List<String>)ImmutableList.of((Object)tableName, (Object)columnName), null, pos, (List<SqlParserPos>)ImmutableList.of((Object)SqlParserPos.ZERO, (Object)pos));
            }
        }
        SqlValidatorNamespace fromNs = null;
        SqlValidatorScope.Path fromPath = null;
        RelDataType fromRowType = null;
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        int size = identifier.names.size();
        for (i = size - 1; i > 0; --i) {
            SqlIdentifier prefix = identifier.getComponent(0, i);
            resolved.clear();
            this.resolve((List<String>)prefix.names, nameMatcher, false, resolved);
            if (resolved.count() == 1) {
                SqlValidatorScope.Resolve resolve = resolved.only();
                fromNs = resolve.namespace;
                fromPath = resolve.path;
                fromRowType = resolve.rowType();
                break;
            }
            if (!nameMatcher.isCaseSensitive()) continue;
            SqlNameMatcher liberalMatcher = SqlNameMatchers.liberal();
            resolved.clear();
            this.resolve((List<String>)prefix.names, liberalMatcher, false, resolved);
            if (resolved.count() != 1) continue;
            SqlValidatorScope.Step lastStep = Util.last(resolved.only().path.steps());
            throw this.validator.newValidationError(prefix, Static.RESOURCE.tableNameNotFoundDidYouMean(prefix.toString(), lastStep.name));
        }
        if (fromNs == null || fromNs instanceof SchemaNamespace) {
            columnName = (String)identifier.names.get(0);
            Map<String, ScopeChild> map = this.findQualifyingTableNames(columnName, identifier, nameMatcher);
            switch (map.size()) {
                default: {
                    SqlIdentifier prefix1 = identifier.skipLast(1);
                    throw this.validator.newValidationError(prefix1, Static.RESOURCE.tableNameNotFound(prefix1.toString()));
                }
                case 1: 
            }
            Map.Entry<String, ScopeChild> entry = map.entrySet().iterator().next();
            String tableName2 = map.keySet().iterator().next();
            fromNs = entry.getValue().namespace;
            fromPath = SqlValidatorScope.Path.EMPTY;
            RelDataTypeField field = nameMatcher.field(fromNs.getRowType(), columnName);
            if (field != null) {
                switch (field.getType().getStructKind()) {
                    case PEEK_FIELDS: 
                    case PEEK_FIELDS_DEFAULT: 
                    case PEEK_FIELDS_NO_EXPAND: {
                        columnName = field.getName();
                        this.resolve((List<String>)ImmutableList.of((Object)tableName2), nameMatcher, false, resolved);
                        if (resolved.count() != 1) break;
                        SqlValidatorScope.Resolve resolve = resolved.only();
                        fromNs = resolve.namespace;
                        fromPath = resolve.path;
                        fromRowType = resolve.rowType();
                        identifier = identifier.setName(0, columnName).add(0, tableName2, SqlParserPos.ZERO);
                        ++i;
                        ++size;
                        break;
                    }
                    default: {
                        SqlIdentifier prefix = identifier.skipLast(1);
                        throw this.validator.newValidationError(prefix, Static.RESOURCE.tableNameNotFound(prefix.toString()));
                    }
                }
            }
        }
        if (fromNs.getEnclosingNode() != null && !(this instanceof MatchRecognizeScope) && (alias = SqlValidatorUtil.getAlias(fromNs.getEnclosingNode(), -1)) != null && i > 0 && !((String)alias).equals(identifier.names.get(i - 1))) {
            identifier = identifier.setName(i - 1, (String)alias);
        }
        if (fromPath.stepCount() > 1) {
            assert (fromRowType != null);
            for (SqlValidatorScope.Step p : fromPath.steps()) {
                fromRowType = fromRowType.getFieldList().get(p.i).getType();
            }
            ++i;
        }
        SqlIdentifier suffix = identifier.getComponent(i, size);
        resolved.clear();
        this.resolveInNamespace(fromNs, false, (List<String>)suffix.names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
        switch (resolved.count()) {
            case 0: {
                int k;
                if (nameMatcher.isCaseSensitive()) {
                    SqlNameMatcher liberalMatcher = SqlNameMatchers.liberal();
                    resolved.clear();
                    this.resolveInNamespace(fromNs, false, (List<String>)suffix.names, liberalMatcher, SqlValidatorScope.Path.EMPTY, resolved);
                    if (resolved.count() > 0) {
                        int k2 = size - 1;
                        SqlIdentifier prefix = identifier.getComponent(0, i);
                        SqlIdentifier suffix3 = identifier.getComponent(i, k2 + 1);
                        SqlValidatorScope.Step step = Util.last(resolved.resolves.get((int)0).path.steps());
                        throw this.validator.newValidationError(suffix3, Static.RESOURCE.columnNotFoundInTableDidYouMean(suffix3.toString(), prefix.toString(), step.name));
                    }
                }
                for (k = size - 1; k > i; --k) {
                    SqlIdentifier suffix2 = identifier.getComponent(i, k);
                    resolved.clear();
                    this.resolveInNamespace(fromNs, false, (List<String>)suffix2.names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
                    if (resolved.count() > 0) break;
                }
                SqlIdentifier prefix = identifier.getComponent(0, i);
                SqlIdentifier suffix3 = identifier.getComponent(i, k + 1);
                throw this.validator.newValidationError(suffix3, Static.RESOURCE.columnNotFoundInTable(suffix3.toString(), prefix.toString()));
            }
            case 1: {
                path = resolved.only().path;
                break;
            }
            default: {
                Comparator<SqlValidatorScope.Resolve> c = new Comparator<SqlValidatorScope.Resolve>(){

                    @Override
                    public int compare(SqlValidatorScope.Resolve o1, SqlValidatorScope.Resolve o2) {
                        int c = Integer.compare(this.worstKind(o1.path), this.worstKind(o2.path));
                        if (c != 0) {
                            return c;
                        }
                        return Integer.compare(o1.path.stepCount(), o2.path.stepCount());
                    }

                    private int worstKind(SqlValidatorScope.Path path) {
                        int kind = -1;
                        for (SqlValidatorScope.Step step : path.steps()) {
                            kind = Math.max(kind, step.kind.ordinal());
                        }
                        return kind;
                    }
                };
                Collections.sort(resolved.resolves, c);
                if (c.compare(resolved.resolves.get(0), resolved.resolves.get(1)) == 0) {
                    throw this.validator.newValidationError(suffix, Static.RESOURCE.columnAmbiguous(suffix.toString()));
                }
                path = resolved.resolves.get((int)0).path;
            }
        }
        int k = i;
        for (SqlValidatorScope.Step step : path.steps()) {
            String name = (String)identifier.names.get(k);
            if (step.i < 0) {
                throw this.validator.newValidationError(identifier, Static.RESOURCE.columnNotFound(name));
            }
            RelDataTypeField field0 = step.rowType.getFieldList().get(step.i);
            String fieldName = field0.getName();
            switch (step.kind) {
                case PEEK_FIELDS: 
                case PEEK_FIELDS_DEFAULT: 
                case PEEK_FIELDS_NO_EXPAND: {
                    identifier = identifier.add(k, fieldName, SqlParserPos.ZERO);
                    break;
                }
                default: {
                    if (!fieldName.equals(name)) {
                        identifier = identifier.setName(k, fieldName);
                    }
                    if (!this.hasAmbiguousUnresolvedStar(step.rowType, field0, name)) break;
                    throw this.validator.newValidationError(identifier, Static.RESOURCE.columnAmbiguous(name));
                }
            }
            ++k;
        }
        if (identifier.names.size() > k) {
            identifier = identifier.getComponent(0, k);
        }
        if (i > 1) {
            identifier = identifier.getComponent(i - 1, identifier.names.size());
        }
        if (!previous.equals(identifier)) {
            this.validator.setOriginal(identifier, previous);
        }
        return SqlQualified.create(this, i, fromNs, identifier);
    }

    @Override
    public void validateExpr(SqlNode expr) {
    }

    @Override
    public SqlWindow lookupWindow(String name) {
        return this.parent.lookupWindow(name);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        return this.parent.getMonotonicity(expr);
    }

    @Override
    public SqlNodeList getOrderList() {
        return this.parent.getOrderList();
    }

    private boolean hasAmbiguousUnresolvedStar(RelDataType rowType, RelDataTypeField field, String columnName) {
        if (field.isDynamicStar() && !DynamicRecordType.isDynamicStarColName(columnName)) {
            int count = 0;
            for (RelDataTypeField possibleStar : rowType.getFieldList()) {
                if (!possibleStar.isDynamicStar() || ++count <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public SqlValidatorScope getParent() {
        return this.parent;
    }
}

