/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.workertoken;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.storm.DaemonConfig;
import org.apache.storm.cluster.IStormClusterState;
import org.apache.storm.generated.PrivateWorkerKey;
import org.apache.storm.generated.WorkerToken;
import org.apache.storm.generated.WorkerTokenInfo;
import org.apache.storm.generated.WorkerTokenServiceType;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.workertoken.WorkerTokenSigner;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerTokenManager {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerTokenManager.class);
    private static final int KEY_LENGTH = 256;
    private final KeyGenerator keyGen;
    private final IStormClusterState state;
    private final long tokenLifetimeMillis;

    public WorkerTokenManager(Map<String, Object> daemonConf, IStormClusterState state) {
        this.state = state;
        try {
            this.keyGen = KeyGenerator.getInstance("HmacSHA256");
            this.keyGen.init(256);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find HmacSHA256 algorithm.");
        }
        this.tokenLifetimeMillis = TimeUnit.MILLISECONDS.convert(ObjectReader.getLong((Object)daemonConf.get(DaemonConfig.STORM_WORKER_TOKEN_LIFE_TIME_HOURS), (Long)24L), TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKey generateSecret() {
        SecretKey key;
        KeyGenerator keyGenerator = this.keyGen;
        synchronized (keyGenerator) {
            key = this.keyGen.generateKey();
        }
        return key;
    }

    protected SecretKey getCurrentSecret() {
        return this.generateSecret();
    }

    public WorkerToken createOrUpdateTokenFor(WorkerTokenServiceType serviceType, String user, String topologyId) {
        long nextVersion = this.state.getNextPrivateWorkerKeyVersion(serviceType, topologyId);
        SecretKey topoSecret = this.getCurrentSecret();
        long expirationTimeMillis = Time.currentTimeMillis() + this.tokenLifetimeMillis;
        WorkerTokenInfo info = new WorkerTokenInfo(user, topologyId, nextVersion, expirationTimeMillis);
        byte[] serializedInfo = ClientAuthUtils.serializeWorkerTokenInfo((WorkerTokenInfo)info);
        byte[] signature = WorkerTokenSigner.createPassword((byte[])serializedInfo, (SecretKey)topoSecret);
        WorkerToken ret = new WorkerToken(serviceType, ByteBuffer.wrap(serializedInfo), ByteBuffer.wrap(signature));
        PrivateWorkerKey key = new PrivateWorkerKey(ByteBuffer.wrap(topoSecret.getEncoded()), user, expirationTimeMillis);
        this.state.addPrivateWorkerKey(serviceType, topologyId, nextVersion, key);
        LOG.info("Created new WorkerToken for user {} topology {} on service {}", new Object[]{user, topologyId, serviceType});
        return ret;
    }

    public void upsertWorkerTokensInCredsForTopo(Map<String, String> creds, String user, String topologyId) {
        Arrays.stream(WorkerTokenServiceType.values()).filter(type -> this.shouldRenewWorkerToken(creds, (WorkerTokenServiceType)type)).forEach(type -> ClientAuthUtils.setWorkerToken((Map)creds, (WorkerToken)this.createOrUpdateTokenFor((WorkerTokenServiceType)type, user, topologyId)));
    }

    @VisibleForTesting
    public boolean shouldRenewWorkerToken(Map<String, String> creds, WorkerTokenServiceType type) {
        boolean shouldAdd = true;
        WorkerToken oldToken = ClientAuthUtils.readWorkerToken(creds, (WorkerTokenServiceType)type);
        if (oldToken != null) {
            try {
                WorkerTokenInfo info = ClientAuthUtils.getWorkerTokenInfo((WorkerToken)oldToken);
                if (!info.is_set_expirationTimeMillis() || info.get_expirationTimeMillis() - Time.currentTimeMillis() > this.tokenLifetimeMillis / 2L) {
                    shouldAdd = false;
                }
            }
            catch (Exception e) {
                LOG.error("Could not deserialize token info", (Throwable)e);
            }
        }
        return shouldAdd;
    }
}

