/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Map;
import org.apache.storm.scheduler.utils.FileConfigLoader;
import org.apache.storm.scheduler.utils.IConfigLoader;
import org.apache.storm.scheduler.utils.IConfigLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={IConfigLoaderFactory.class})
public class FileConfigLoaderFactory
implements IConfigLoaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileConfigLoaderFactory.class);

    @Override
    public IConfigLoader createIfSupported(URI uri, Map<String, Object> conf) {
        String scheme = uri.getScheme();
        if ("file".equalsIgnoreCase(scheme)) {
            return new FileConfigLoader(conf);
        }
        LOG.debug("scheme {} not supported in this factory.", (Object)scheme);
        return null;
    }
}

