/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling.sorter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.ObjectResourcesItem;
import org.apache.storm.scheduler.resource.strategies.scheduling.ObjectResourcesSummary;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.INodeSorter;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSorterHostProximity
implements INodeSorter {
    private static final Logger LOG = LoggerFactory.getLogger(NodeSorterHostProximity.class);
    protected final BaseResourceAwareStrategy.NodeSortType nodeSortType;
    protected Cluster cluster;
    protected TopologyDetails topologyDetails;
    private final Map<String, String> superIdToRack = new HashMap<String, String>();
    private final Map<String, List<RasNode>> hostnameToNodes = new HashMap<String, List<RasNode>>();
    private final Map<String, String> nodeIdToHostname = new HashMap<String, String>();
    private final Map<String, Set<String>> rackIdToHosts = new HashMap<String, Set<String>>();
    protected List<String> greyListedSupervisorIds;
    protected List<String> favoredNodeIds;
    protected List<String> unFavoredNodeIds;
    ExecutorDetails exec;

    public NodeSorterHostProximity(Cluster cluster, TopologyDetails topologyDetails) {
        this(cluster, topologyDetails, BaseResourceAwareStrategy.NodeSortType.COMMON);
    }

    public NodeSorterHostProximity(Cluster cluster, TopologyDetails topologyDetails, BaseResourceAwareStrategy.NodeSortType nodeSortType) {
        this.cluster = cluster;
        this.topologyDetails = topologyDetails;
        this.nodeSortType = nodeSortType;
        this.greyListedSupervisorIds = cluster.getGreyListedSupervisors();
        Map<String, String> hostToRack = cluster.getHostToRack();
        RasNodes nodes = new RasNodes(cluster);
        for (RasNode node : nodes.getNodes()) {
            String superId = node.getId();
            String hostName = node.getHostname();
            if (!node.isAlive() || hostName == null) continue;
            String rackId = hostToRack.getOrDefault(hostName, "/default-rack");
            this.superIdToRack.put(superId, rackId);
            this.hostnameToNodes.computeIfAbsent(hostName, hn -> new ArrayList()).add(node);
            this.nodeIdToHostname.put(superId, hostName);
            this.rackIdToHosts.computeIfAbsent(rackId, r -> new HashSet()).add(hostName);
        }
        Map<String, Object> topoConf = topologyDetails.getConf();
        this.favoredNodeIds = this.makeHostToNodeIds((List)topoConf.get("topology.scheduler.favored.nodes"));
        this.unFavoredNodeIds = this.makeHostToNodeIds((List)topoConf.get("topology.scheduler.unfavored.nodes"));
        this.favoredNodeIds.removeAll(this.greyListedSupervisorIds);
        this.unFavoredNodeIds.removeAll(this.greyListedSupervisorIds);
        this.unFavoredNodeIds.removeAll(this.favoredNodeIds);
    }

    @VisibleForTesting
    public Map<String, Set<String>> getRackIdToHosts() {
        return this.rackIdToHosts;
    }

    @Override
    public void prepare(ExecutorDetails exec) {
        this.exec = exec;
    }

    protected Iterable<ObjectResourcesItem> sortObjectResources(ObjectResourcesSummary resourcesSummary, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        switch (this.nodeSortType) {
            case DEFAULT_RAS: {
                return this.sortObjectResourcesDefault(resourcesSummary, existingScheduleFunc);
            }
            case GENERIC_RAS: {
                return this.sortObjectResourcesGeneric(resourcesSummary, exec, existingScheduleFunc);
            }
            case COMMON: {
                return this.sortObjectResourcesCommon(resourcesSummary, exec, existingScheduleFunc);
            }
        }
        return null;
    }

    private Iterable<ObjectResourcesItem> sortObjectResourcesCommon(ObjectResourcesSummary allResources, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        ObjectResourcesSummary affinityBasedAllResources = new ObjectResourcesSummary(allResources);
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        NormalizedResourceRequest requestedResources = exec != null ? this.topologyDetails.getTotalResources(exec) : null;
        affinityBasedAllResources.getObjectResources().forEach(x -> {
            if (requestedResources != null) {
                x.availableResources.updateForRareResourceAffinity(requestedResources);
            }
            x.minResourcePercent = availableResourcesOverall.calculateMinPercentageUsedBy(x.availableResources);
            x.avgResourcePercent = availableResourcesOverall.calculateAveragePercentageUsedBy(x.availableResources);
            LOG.trace("for {}: minResourcePercent={}, avgResourcePercent={}, numExistingSchedule={}", new Object[]{x.id, x.minResourcePercent, x.avgResourcePercent, existingScheduleFunc.getNumExistingSchedule(x.id)});
        });
        Comparator comparator = (o1, o2) -> {
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            double o1Avg = o1.avgResourcePercent;
            double o2Avg = o2.avgResourcePercent;
            if (o1Avg > o2Avg) {
                return -1;
            }
            if (o1Avg < o2Avg) {
                return 1;
            }
            if (o1.minResourcePercent > o2.minResourcePercent) {
                return -1;
            }
            if (o1.minResourcePercent < o2.minResourcePercent) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        TreeSet<ObjectResourcesItem> sortedObjectResources = new TreeSet<ObjectResourcesItem>(comparator);
        sortedObjectResources.addAll(affinityBasedAllResources.getObjectResources());
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    @Deprecated
    private Iterable<ObjectResourcesItem> sortObjectResourcesGeneric(ObjectResourcesSummary allResources, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        ObjectResourcesSummary affinityBasedAllResources = new ObjectResourcesSummary(allResources);
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        NormalizedResourceRequest requestedResources = exec != null ? this.topologyDetails.getTotalResources(exec) : null;
        affinityBasedAllResources.getObjectResources().forEach(x -> {
            if (requestedResources != null) {
                x.availableResources.updateForRareResourceAffinity(requestedResources);
            }
            x.minResourcePercent = availableResourcesOverall.calculateMinPercentageUsedBy(x.availableResources);
            x.avgResourcePercent = availableResourcesOverall.calculateAveragePercentageUsedBy(x.availableResources);
            LOG.trace("for {}: minResourcePercent={}, avgResourcePercent={}, numExistingSchedule={}", new Object[]{x.id, x.minResourcePercent, x.avgResourcePercent, existingScheduleFunc.getNumExistingSchedule(x.id)});
        });
        Comparator comparator = (o1, o2) -> {
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            double o1Avg = o1.avgResourcePercent;
            double o2Avg = o2.avgResourcePercent;
            if (o1Avg > o2Avg) {
                return -1;
            }
            if (o1Avg < o2Avg) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        TreeSet<ObjectResourcesItem> sortedObjectResources = new TreeSet<ObjectResourcesItem>(comparator);
        sortedObjectResources.addAll(affinityBasedAllResources.getObjectResources());
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    @Deprecated
    private Iterable<ObjectResourcesItem> sortObjectResourcesDefault(ObjectResourcesSummary allResources, ExistingScheduleFunc existingScheduleFunc) {
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        for (ObjectResourcesItem objectResources : allResources.getObjectResources()) {
            objectResources.minResourcePercent = availableResourcesOverall.calculateMinPercentageUsedBy(objectResources.availableResources);
            objectResources.avgResourcePercent = availableResourcesOverall.calculateAveragePercentageUsedBy(objectResources.availableResources);
            LOG.trace("for {}: minResourcePercent={}, avgResourcePercent={}, numExistingSchedule={}", new Object[]{objectResources.id, objectResources.minResourcePercent, objectResources.avgResourcePercent, existingScheduleFunc.getNumExistingSchedule(objectResources.id)});
        }
        Comparator comparator = (o1, o2) -> {
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            if (o1.minResourcePercent > o2.minResourcePercent) {
                return -1;
            }
            if (o1.minResourcePercent < o2.minResourcePercent) {
                return 1;
            }
            double diff = o1.avgResourcePercent - o2.avgResourcePercent;
            if (diff > 0.0) {
                return -1;
            }
            if (diff < 0.0) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        TreeSet<ObjectResourcesItem> sortedObjectResources = new TreeSet<ObjectResourcesItem>(comparator);
        sortedObjectResources.addAll(allResources.getObjectResources());
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    private Iterable<ObjectResourcesItem> sortHosts(Collection<String> availHosts, ExecutorDetails exec, String rackId, Map<String, AtomicInteger> scheduledCount) {
        ObjectResourcesSummary rackResourcesSummary = new ObjectResourcesSummary("RACK");
        availHosts.forEach(h -> {
            ObjectResourcesItem hostItem = new ObjectResourcesItem((String)h);
            for (RasNode x : this.hostnameToNodes.get(h)) {
                hostItem.add(new ObjectResourcesItem(x.getId(), x.getTotalAvailableResources(), x.getTotalResources(), 0.0, 0.0));
            }
            rackResourcesSummary.addObjectResourcesItem(hostItem);
        });
        LOG.debug("Rack {}: Overall Avail [ {} ] Total [ {} ]", new Object[]{rackId, rackResourcesSummary.getAvailableResourcesOverall(), rackResourcesSummary.getTotalResourcesOverall()});
        return this.sortObjectResources(rackResourcesSummary, exec, hostId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(hostId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    private Iterable<ObjectResourcesItem> sortNodes(List<RasNode> availRasNodes, ExecutorDetails exec, String hostId, Map<String, AtomicInteger> scheduledCount) {
        ObjectResourcesSummary hostResourcesSummary = new ObjectResourcesSummary("HOST");
        availRasNodes.forEach(x -> hostResourcesSummary.addObjectResourcesItem(new ObjectResourcesItem(x.getId(), x.getTotalAvailableResources(), x.getTotalResources(), 0.0, 0.0)));
        LOG.debug("Host {}: Overall Avail [ {} ] Total [ {} ]", new Object[]{hostId, hostResourcesSummary.getAvailableResourcesOverall(), hostResourcesSummary.getTotalResourcesOverall()});
        return this.sortObjectResources(hostResourcesSummary, exec, superId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(superId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    protected List<String> makeHostToNodeIds(List<String> hosts) {
        if (hosts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(hosts.size());
        for (String host : hosts) {
            List<RasNode> nodes = this.hostnameToNodes.get(host);
            if (nodes == null) continue;
            for (RasNode node : nodes) {
                ret.add(node.getId());
            }
        }
        return ret;
    }

    @Override
    public Iterable<String> sortAllNodes() {
        return new LazyNodeSorting(this.exec);
    }

    private ObjectResourcesSummary createClusterSummarizedResources() {
        ObjectResourcesSummary clusterResourcesSummary = new ObjectResourcesSummary("Cluster");
        this.rackIdToHosts.forEach((rackId, hostIds) -> {
            if (hostIds == null || hostIds.isEmpty()) {
                LOG.info("Ignoring Rack {} since it has no hosts", rackId);
            } else {
                ObjectResourcesItem rack = new ObjectResourcesItem((String)rackId);
                for (String hostId : hostIds) {
                    for (RasNode node : this.hostnameToNodes(hostId)) {
                        rack.availableResources.add(node.getTotalAvailableResources());
                        rack.totalResources.add(node.getTotalResources());
                    }
                }
                clusterResourcesSummary.addObjectResourcesItem(rack);
            }
        });
        LOG.debug("Cluster Overall Avail [ {} ] Total [ {} ], rackCnt={}, hostCnt={}", new Object[]{clusterResourcesSummary.getAvailableResourcesOverall(), clusterResourcesSummary.getTotalResourcesOverall(), clusterResourcesSummary.getObjectResources().size(), this.rackIdToHosts.values().stream().mapToInt(x -> x.size()).sum()});
        return clusterResourcesSummary;
    }

    public Map<String, AtomicInteger> getScheduledExecCntByRackId() {
        SchedulerAssignment assignment = this.cluster.getAssignmentById(this.topologyDetails.getId());
        HashMap<String, AtomicInteger> scheduledCount = new HashMap<String, AtomicInteger>();
        if (assignment != null) {
            for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                String superId = entry.getKey().getNodeId();
                String rackId = this.superIdToRack.get(superId);
                scheduledCount.computeIfAbsent(rackId, rid -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
            }
        }
        return scheduledCount;
    }

    @Override
    public Iterable<ObjectResourcesItem> getSortedRacks() {
        ObjectResourcesSummary clusterResourcesSummary = this.createClusterSummarizedResources();
        Map<String, AtomicInteger> scheduledCount = this.getScheduledExecCntByRackId();
        return this.sortObjectResources(clusterResourcesSummary, this.exec, rackId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(rackId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    public List<RasNode> hostnameToNodes(String hostname) {
        return this.hostnameToNodes.getOrDefault(hostname, Collections.emptyList());
    }

    public static interface ExistingScheduleFunc {
        public int getNumExistingSchedule(String var1);
    }

    private class LazyNodeSorting
    implements Iterable<String> {
        private final Map<String, AtomicInteger> perHostScheduledCount = new HashMap<String, AtomicInteger>();
        private final Map<String, AtomicInteger> perNodeScheduledCount = new HashMap<String, AtomicInteger>();
        private final Iterable<ObjectResourcesItem> sortedRacks;
        private final Map<String, Iterable<ObjectResourcesItem>> cachedHosts = new HashMap<String, Iterable<ObjectResourcesItem>>();
        private final Map<String, Iterable<ObjectResourcesItem>> cachedNodesByHost = new HashMap<String, Iterable<ObjectResourcesItem>>();
        private final ExecutorDetails exec;
        private final Set<String> skippedNodeIds = new HashSet<String>();

        LazyNodeSorting(ExecutorDetails exec) {
            this.exec = exec;
            this.skippedNodeIds.addAll(NodeSorterHostProximity.this.favoredNodeIds);
            this.skippedNodeIds.addAll(NodeSorterHostProximity.this.unFavoredNodeIds);
            this.skippedNodeIds.addAll(NodeSorterHostProximity.this.greyListedSupervisorIds);
            String topoId = NodeSorterHostProximity.this.topologyDetails.getId();
            SchedulerAssignment assignment = NodeSorterHostProximity.this.cluster.getAssignmentById(topoId);
            if (assignment != null) {
                for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                    String superId = entry.getKey().getNodeId();
                    String hostId = NodeSorterHostProximity.this.nodeIdToHostname.get(superId);
                    this.perHostScheduledCount.computeIfAbsent(hostId, id -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
                    this.perNodeScheduledCount.computeIfAbsent(superId, id -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
                }
            }
            this.sortedRacks = NodeSorterHostProximity.this.getSortedRacks();
        }

        private Iterable<ObjectResourcesItem> getSortedHostsForRack(String rackId) {
            return this.cachedHosts.computeIfAbsent(rackId, id -> NodeSorterHostProximity.this.sortHosts(NodeSorterHostProximity.this.rackIdToHosts.getOrDefault(id, Collections.emptySet()), this.exec, (String)id, this.perHostScheduledCount));
        }

        private Iterable<ObjectResourcesItem> getSortedNodesForHost(String hostId) {
            return this.cachedNodesByHost.computeIfAbsent(hostId, id -> NodeSorterHostProximity.this.sortNodes(NodeSorterHostProximity.this.hostnameToNodes.getOrDefault(id, Collections.emptyList()), this.exec, (String)id, this.perNodeScheduledCount));
        }

        @Override
        public Iterator<String> iterator() {
            return new LazyNodeSortingIterator(this, this.sortedRacks);
        }
    }

    private class LazyNodeSortingIterator
    implements Iterator<String> {
        private final LazyNodeSorting parent;
        private final Iterator<ObjectResourcesItem> rackIterator;
        private Iterator<ObjectResourcesItem> hostIterator;
        private Iterator<ObjectResourcesItem> nodeIterator;
        private String nextValueFromNode = null;
        private final Iterator<String> pre;
        private final Iterator<String> post;
        private final Set<String> skip;

        LazyNodeSortingIterator(LazyNodeSorting parent, Iterable<ObjectResourcesItem> sortedRacks) {
            this.parent = parent;
            this.rackIterator = sortedRacks.iterator();
            this.pre = NodeSorterHostProximity.this.favoredNodeIds.iterator();
            this.post = Stream.concat(NodeSorterHostProximity.this.unFavoredNodeIds.stream(), NodeSorterHostProximity.this.greyListedSupervisorIds.stream()).collect(Collectors.toList()).iterator();
            this.skip = parent.skippedNodeIds;
        }

        private Iterator<ObjectResourcesItem> getNodeIterator() {
            if (this.nodeIterator != null && this.nodeIterator.hasNext()) {
                return this.nodeIterator;
            }
            if (this.hostIterator != null && this.hostIterator.hasNext()) {
                ObjectResourcesItem host = this.hostIterator.next();
                String hostId = host.id;
                this.nodeIterator = this.parent.getSortedNodesForHost(hostId).iterator();
                return this.nodeIterator;
            }
            if (this.rackIterator.hasNext()) {
                ObjectResourcesItem rack = this.rackIterator.next();
                String rackId = rack.id;
                this.hostIterator = this.parent.getSortedHostsForRack(rackId).iterator();
                ObjectResourcesItem host = this.hostIterator.next();
                String hostId = host.id;
                this.nodeIterator = this.parent.getSortedNodesForHost(hostId).iterator();
                return this.nodeIterator;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            Iterator<ObjectResourcesItem> nodeIterator;
            if (this.pre.hasNext()) {
                return true;
            }
            if (this.nextValueFromNode != null) {
                return true;
            }
            while ((nodeIterator = this.getNodeIterator()) != null && nodeIterator.hasNext()) {
                String tmp = nodeIterator.next().id;
                if (this.skip.contains(tmp)) continue;
                this.nextValueFromNode = tmp;
                return true;
            }
            return this.post.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pre.hasNext()) {
                return this.pre.next();
            }
            if (this.nextValueFromNode != null) {
                String tmp = this.nextValueFromNode;
                this.nextValueFromNode = null;
                return tmp;
            }
            return this.post.next();
        }
    }
}

