/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.DefaultResourceIsolationManager;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.daemon.supervisor.BasicContainerLauncher;
import org.apache.storm.daemon.supervisor.Container;
import org.apache.storm.daemon.supervisor.ContainerMemoryTracker;
import org.apache.storm.daemon.supervisor.ContainerRecoveryException;
import org.apache.storm.daemon.supervisor.Killable;
import org.apache.storm.daemon.supervisor.LocalContainerLauncher;
import org.apache.storm.generated.LocalAssignment;
import org.apache.storm.generated.Supervisor;
import org.apache.storm.messaging.IContext;
import org.apache.storm.metric.StormMetricsRegistry;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.LocalState;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerLauncher.class);

    protected ContainerLauncher() {
    }

    public static ContainerLauncher make(Map<String, Object> conf, String supervisorId, int supervisorPort, IContext sharedContext, StormMetricsRegistry metricsRegistry, ContainerMemoryTracker containerMemoryTracker, Supervisor.Iface localSupervisor) throws IOException {
        ResourceIsolationInterface resourceIsolationManager;
        if (ConfigUtils.isLocalMode(conf)) {
            return new LocalContainerLauncher(conf, supervisorId, supervisorPort, sharedContext, metricsRegistry, containerMemoryTracker, localSupervisor);
        }
        if (ObjectReader.getBoolean((Object)conf.get("storm.resource.isolation.plugin.enable"), (boolean)false)) {
            resourceIsolationManager = (ResourceIsolationInterface)ReflectionUtils.newInstance((String)((String)conf.get("storm.resource.isolation.plugin")));
            LOG.info("Using resource isolation plugin {}: {}", conf.get("storm.resource.isolation.plugin"), (Object)resourceIsolationManager);
        } else {
            resourceIsolationManager = new DefaultResourceIsolationManager();
            LOG.info("{} is false. Using default resource isolation plugin: {}", (Object)"storm.resource.isolation.plugin.enable", (Object)resourceIsolationManager);
        }
        resourceIsolationManager.prepare(conf);
        return new BasicContainerLauncher(conf, supervisorId, supervisorPort, resourceIsolationManager, metricsRegistry, containerMemoryTracker);
    }

    public abstract Container launchContainer(int var1, LocalAssignment var2, LocalState var3) throws IOException;

    public abstract Container recoverContainer(int var1, LocalAssignment var2, LocalState var3) throws IOException, ContainerRecoveryException;

    public abstract Killable recoverContainer(String var1, LocalState var2) throws IOException, ContainerRecoveryException;
}

