/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.ILocalDRPC;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DistributedRPC;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DRPCClient
extends ThriftClient
implements DistributedRPC.Iface {
    private static final Logger LOG = LoggerFactory.getLogger(DRPCClient.class);
    private static volatile ILocalDRPC localOverrideClient = null;
    private DistributedRPC.Iface client;
    private String host;
    private int port;

    private DRPCClient(DistributedRPC.Iface override) {
        super(new HashMap<String, Object>(), ThriftConnectionType.LOCAL_FAKE, "localhost", 1234, null, null);
        this.host = "localhost";
        this.port = 1234;
        this.client = override;
    }

    public DRPCClient(Map<String, Object> conf, String host, int port) throws TTransportException {
        this(conf, host, port, null);
        this.retryForever = true;
    }

    public DRPCClient(Map<String, Object> conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, localOverrideClient != null ? ThriftConnectionType.LOCAL_FAKE : ThriftConnectionType.DRPC, host, port, timeout, null);
        this.host = host;
        this.port = port;
        this.client = localOverrideClient != null ? localOverrideClient : new DistributedRPC.Client(this.protocol);
        this.retryForever = true;
    }

    public static boolean isLocalOverride() {
        return localOverrideClient != null;
    }

    public static String getOverrideServiceId() {
        return localOverrideClient.getServiceId();
    }

    public static DRPCClient getConfiguredClient(Map<String, Object> conf) throws TTransportException {
        ILocalDRPC override = localOverrideClient;
        if (override != null) {
            return new DRPCClient(override);
        }
        Map<String, Object> fullConf = Utils.readStormConfig();
        fullConf.putAll(Utils.readCommandLineOpts());
        fullConf.putAll(conf);
        int port = ObjectReader.getInt(fullConf.get("drpc.port"), 3772);
        List servers = (List)fullConf.get("drpc.servers");
        if (servers == null) {
            throw new IllegalStateException("drpc.servers is not set, could not find any DRPC servers to connect to.");
        }
        Collections.shuffle(servers);
        RuntimeException excpt = null;
        for (String host : servers) {
            try {
                return new DRPCClient(fullConf, host, port);
            }
            catch (RuntimeException e) {
                if (Utils.exceptionCauseIsInstanceOf(ConnectException.class, e)) {
                    excpt = e;
                    continue;
                }
                throw e;
            }
        }
        if (excpt != null) {
            throw excpt;
        }
        throw new IllegalStateException("It appears that no drpc servers were configured.");
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String execute(String func, String args) throws TException, DRPCExecutionException, AuthorizationException {
        if (func == null) {
            throw new IllegalArgumentException("DRPC Function cannot be null");
        }
        LOG.debug("DRPC RUNNING \"{}\"(\"{}\")", (Object)func, (Object)args);
        return this.client.execute(func, args);
    }

    public DistributedRPC.Iface getClient() {
        return this.client;
    }

    public static class LocalOverride
    implements AutoCloseable {
        public LocalOverride(ILocalDRPC client) {
            localOverrideClient = client;
        }

        @Override
        public void close() throws Exception {
            localOverrideClient = null;
        }
    }
}

