/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.partition;

import java.util.Arrays;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.utils.Utils;

public class IndexHashGrouping
implements CustomStreamGrouping {
    int index;
    List<Integer> targets;

    public IndexHashGrouping(int index) {
        this.index = index;
    }

    public static int objectToIndex(Object val, int numPartitions) {
        if (val == null) {
            return 0;
        }
        return Utils.toPositive(val.hashCode()) % numPartitions;
    }

    @Override
    public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        this.targets = targetTasks;
    }

    @Override
    public List<Integer> chooseTasks(int fromTask, List<Object> values) {
        int i = IndexHashGrouping.objectToIndex(values.get(this.index), this.targets.size());
        return Arrays.asList(this.targets.get(i));
    }
}

