/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.storm.security.auth.tls.ReloadableX509KeyManager;
import org.apache.storm.security.auth.tls.ReloadableX509TrustManager;
import org.apache.storm.shade.io.netty.handler.ssl.ClientAuth;
import org.apache.storm.shade.io.netty.handler.ssl.OpenSsl;
import org.apache.storm.shade.io.netty.handler.ssl.SslContext;
import org.apache.storm.shade.io.netty.handler.ssl.SslContextBuilder;
import org.apache.storm.shade.io.netty.handler.ssl.SslProvider;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTlsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTlsUtils.class);

    public static SslContext createSslContext(Map<String, Object> topoConf, boolean forServer) {
        Set<String> ciphers;
        boolean enableTls = ObjectReader.getBoolean(topoConf.get("storm.messaging.netty.tls.enable"), false);
        if (!enableTls) {
            return null;
        }
        boolean requireOpenSsl = ObjectReader.getBoolean(topoConf.get("storm.messaging.netty.tls.require.open.ssl"), false);
        if (requireOpenSsl) {
            OpenSsl.ensureAvailability();
        }
        if (topoConf.containsKey("storm.messaging.netty.tls.ciphers")) {
            ciphers = new HashSet<String>();
            ciphers.addAll(ObjectReader.getStrings(topoConf.get("storm.messaging.netty.tls.ciphers")));
        } else {
            ciphers = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256")));
        }
        String protocols = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.ssl.protocols"), "TLSv1.3");
        SslContext sslContext = null;
        try {
            SslContextBuilder builder;
            if (forServer) {
                LOG.info("Building SSL context for Netty server");
                String keystorePath = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.keystore.path"));
                String keystorePassword = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.keystore.password"));
                String truststorePath = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.truststore.path"));
                String truststorePassword = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.truststore.password"));
                builder = SslContextBuilder.forServer((KeyManager)new ReloadableX509KeyManager(keystorePath, keystorePassword)).trustManager((TrustManager)new ReloadableX509TrustManager(truststorePath, truststorePassword)).clientAuth(ClientAuth.REQUIRE);
            } else {
                LOG.info("Building SSL context for Netty client");
                String clientKeystorePath = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.client.keystore.path"));
                String clientKeystorePassword = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.client.keystore.password"));
                String clientTruststorePath = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.client.truststore.path"));
                String clientTruststorePassword = ObjectReader.getString(topoConf.get("storm.messaging.netty.tls.client.truststore.password"));
                builder = SslContextBuilder.forClient();
                builder.keyManager((KeyManager)new ReloadableX509KeyManager(clientKeystorePath, clientKeystorePassword)).trustManager((TrustManager)new ReloadableX509TrustManager(clientTruststorePath, clientTruststorePassword));
            }
            builder.ciphers(ciphers).startTls(false).protocols(new String[]{protocols});
            if (requireOpenSsl) {
                builder.sslProvider(SslProvider.OPENSSL);
            }
            sslContext = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sslContext;
    }
}

