/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FindInSet$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, str_array) - Returns the index (1-based) of the given string (`str`) in the comma-delimited list (`str_array`).\n      Returns 0, if the string was not found or if the given string (`str`) contains a comma.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ab','abc,b,ab,c,def');\n       3\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001\u0002\u0011\"\u0001:B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011!Q\u0006\u0001#b\u0001\n\u000bY\u0006\"B0\u0001\t\u0003\u0002\u0007\"\u00026\u0001\t\u00032\u0006\"B6\u0001\t#b\u0007\"\u0002;\u0001\t\u0003*\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\t)\u0003\u0001C)\u0003OA\u0011\"!\r\u0001\u0003\u0003%\t!a\r\t\u0013\u0005e\u0002!%A\u0005\u0002\u0005m\u0002\"CA)\u0001E\u0005I\u0011AA\u001e\u0011%\t\u0019\u0006AA\u0001\n\u0003\n)\u0006\u0003\u0005\u0002f\u0001\t\t\u0011\"\u0001\\\u0011%\t9\u0007AA\u0001\n\u0003\tI\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u000b\u0003\u0011\u0011!C!\u0003\u000fC\u0011\"a#\u0001\u0003\u0003%\t%!$\b\u0013\u0005E\u0016%!A\t\u0002\u0005Mf\u0001\u0003\u0011\"\u0003\u0003E\t!!.\t\rASB\u0011AAg\u0011%\tyMGA\u0001\n\u000b\n\t\u000eC\u0005\u0002Tj\t\t\u0011\"!\u0002V\"I\u00111\u001c\u000e\u0002\u0002\u0013\u0005\u0015Q\u001c\u0005\n\u0003_T\u0012\u0011!C\u0005\u0003c\u0014\u0011BR5oI&s7+\u001a;\u000b\u0005\t\u001a\u0013aC3yaJ,7o]5p]NT!\u0001J\u0013\u0002\u0011\r\fG/\u00197zgRT!AJ\u0014\u0002\u0007M\fHN\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00184mq\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00195\u0013\t)\u0014E\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"!P#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!.\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002Eq\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0005(\u0001\u0003mK\u001a$X#\u0001&\u0011\u0005AZ\u0015B\u0001'\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r\u00116\u000b\u0016\t\u0003a\u0001AQ\u0001S\u0003A\u0002)CQAT\u0003A\u0002)\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001X!\t9\u0004,\u0003\u0002Zq\t9!i\\8mK\u0006t\u0017aC2pY2\fG/[8o\u0013\u0012,\u0012\u0001\u0018\t\u0003ouK!A\u0018\u001d\u0003\u0007%sG/\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0019\t\u0004{\t$\u0017BA2H\u0005\r\u0019V-\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u0016\nQ\u0001^=qKNL!!\u001b4\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017AG2p]R,\u0007\u0010^%oI\u0016\u0004XM\u001c3f]R4u\u000e\u001c3bE2,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA7qeB\u0011qG\\\u0005\u0003_b\u00121!\u00118z\u0011\u0015\t(\u00021\u0001n\u0003\u00119xN\u001d3\t\u000bMT\u0001\u0019A7\u0002\u0007M,G/A\u0005e_\u001e+gnQ8eKR!a\u000f`A\u0002!\t9(0D\u0001y\u0015\tI\u0018%A\u0004d_\u0012,w-\u001a8\n\u0005mD(\u0001C#yaJ\u001cu\u000eZ3\t\u000bu\\\u0001\u0019\u0001@\u0002\u0007\r$\b\u0010\u0005\u0002x\u007f&\u0019\u0011\u0011\u0001=\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011QA\u0006A\u0002Y\f!!\u001a<\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0003\u0011\u0007\u0015\fi!C\u0002\u0002\u0010\u0019\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,WCAA\u000b!\u0011\t9\"a\b\u000f\t\u0005e\u00111\u0004\t\u0003\u007faJ1!!\b9\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0004\u001d\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002*\u0002*\u00055\u0002BBA\u0016\u001d\u0001\u0007!*A\u0004oK^dUM\u001a;\t\r\u0005=b\u00021\u0001K\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$RAUA\u001b\u0003oAq\u0001S\b\u0011\u0002\u0003\u0007!\nC\u0004O\u001fA\u0005\t\u0019\u0001&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\b\u0016\u0004\u0015\u0006}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\u0003(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0016\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u00037\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002n\u0003WB\u0001\"!\u001c\u0015\u0003\u0003\u0005\r\u0001X\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\u0004#BA;\u0003wjWBAA<\u0015\r\tI\bO\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA?\u0003o\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019q+a!\t\u0011\u00055d#!AA\u00025\f!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qKAE\u0011!\tigFA\u0001\u0002\u0004a\u0016AB3rk\u0006d7\u000fF\u0002X\u0003\u001fC\u0001\"!\u001c\u0019\u0003\u0003\u0005\r!\u001c\u0015\u0014\u0001\u0005M\u0015\u0011TAN\u0003?\u000b\t+!*\u0002(\u0006-\u0016Q\u0016\t\u0004a\u0005U\u0015bAALC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAO\u0003\u0005\r'\u0002\t\u0011!A}3UKT\"`QM$(\u000f\f\u0011tiJ|\u0016M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013N\u001c3fq\u0002B\u0013'\f2bg\u0016$\u0017\u0006I8gAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007\u0005\u000b1tiJ\u0004\u0017\u0006I5oAQDW\rI2p[6\fW\u0006Z3mS6LG/\u001a3!Y&\u001cH\u000f\t\u0015agR\u0014x,\u0019:sCf\u0004\u0017F\f\u0006!A\u0001\u0002\u0003\u0005\t*fiV\u0014hn\u001d\u00111Y\u0001Jg\r\t;iK\u0002\u001aHO]5oO\u0002:\u0018m\u001d\u0011o_R\u0004cm\\;oI\u0002z'\u000fI5gAQDW\rI4jm\u0016t\u0007e\u001d;sS:<\u0007\u0005\u000b1tiJ\u0004\u0017\u0006I2p]R\f\u0017N\\:!C\u0002\u001aw.\\7b])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019+\u0001%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'm\n\u0017(C\n\u001cGF\u0019\u0017bE2\u001aG\u0006Z3gO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011V\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003_\u000bAb\u001d;sS:<wLZ;oGN\f\u0011BR5oI&s7+\u001a;\u0011\u0005AR2#\u0002\u000e\u00028\u0006\r\u0007cBA]\u0003\u007fS%JU\u0007\u0003\u0003wS1!!09\u0003\u001d\u0011XO\u001c;j[\u0016LA!!1\u0002<\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\u0015\u00171Z\u0007\u0003\u0003\u000fTA!!3\u0002`\u0005\u0011\u0011n\\\u0005\u0004\r\u0006\u001dGCAAZ\u0003!!xn\u0015;sS:<GCAA,\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0011\u0016q[Am\u0011\u0015AU\u00041\u0001K\u0011\u0015qU\u00041\u0001K\u0003\u001d)h.\u00199qYf$B!a8\u0002lB)q'!9\u0002f&\u0019\u00111\u001d\u001d\u0003\r=\u0003H/[8o!\u00159\u0014q\u001d&K\u0013\r\tI\u000f\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u00055h$!AA\u0002I\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\u0019\u0010\u0005\u0003\u0002Z\u0005U\u0018\u0002BA|\u00037\u0012aa\u00142kK\u000e$\b")
public class FindInSet
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression left;
    private final Expression right;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(FindInSet x$0) {
        return FindInSet$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, FindInSet> tupled() {
        return FindInSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, FindInSet>> curried() {
        return FindInSet$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        FindInSet findInSet = this;
        synchronized (findInSet) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.left().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return super.contextIndependentFoldable();
    }

    @Override
    public Object nullSafeEval(Object word, Object set) {
        return BoxesRunTime.boxToInteger((int)CollationSupport.FindInSet.exec((UTF8String)((UTF8String)word), (UTF8String)((UTF8String)set), (int)this.collationId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(word, set) -> CollationSupport.FindInSet.genCode((String)word, (String)set, (int)this.collationId()));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "find_in_set";
    }

    @Override
    public FindInSet withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public FindInSet copy(Expression left, Expression right) {
        return new FindInSet(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "FindInSet";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FindInSet;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FindInSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        FindInSet findInSet = (FindInSet)x$1;
        Expression expression = this.left();
        Expression expression2 = findInSet.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = findInSet.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!findInSet.canEqual(this)) return false;
        return true;
    }

    public FindInSet(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

