/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.netty.handler.codec.http2;

import java.util.concurrent.TimeUnit;
import org.sparkproject.io.netty.channel.ChannelFuture;
import org.sparkproject.io.netty.channel.ChannelHandlerContext;
import org.sparkproject.io.netty.channel.ChannelPromise;
import org.sparkproject.io.netty.handler.codec.http2.DecoratingHttp2ConnectionEncoder;
import org.sparkproject.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.sparkproject.io.netty.handler.codec.http2.Http2Error;
import org.sparkproject.io.netty.handler.codec.http2.Http2Exception;
import org.sparkproject.io.netty.handler.codec.http2.Http2LifecycleManager;
import org.sparkproject.io.netty.util.concurrent.Ticker;
import org.sparkproject.io.netty.util.internal.logging.InternalLogger;
import org.sparkproject.io.netty.util.internal.logging.InternalLoggerFactory;

final class Http2MaxRstFrameLimitEncoder
extends DecoratingHttp2ConnectionEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2MaxRstFrameLimitEncoder.class);
    private final long nanosPerWindow;
    private final int maxRstFramesPerWindow;
    private final Ticker ticker;
    private long lastRstFrameNano;
    private int sendRstInWindow;
    private Http2LifecycleManager lifecycleManager;

    Http2MaxRstFrameLimitEncoder(Http2ConnectionEncoder delegate, int maxRstFramesPerWindow, int secondsPerWindow) {
        this(delegate, maxRstFramesPerWindow, secondsPerWindow, Ticker.systemTicker());
    }

    Http2MaxRstFrameLimitEncoder(Http2ConnectionEncoder delegate, int maxRstFramesPerWindow, int secondsPerWindow, Ticker ticker) {
        super(delegate);
        this.maxRstFramesPerWindow = maxRstFramesPerWindow;
        this.nanosPerWindow = TimeUnit.SECONDS.toNanos(secondsPerWindow);
        this.ticker = ticker;
        this.lastRstFrameNano = ticker.nanoTime();
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
        super.lifecycleManager(lifecycleManager);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext ctx, int streamId, long errorCode, ChannelPromise promise) {
        ChannelFuture future = super.writeRstStream(ctx, streamId, errorCode, promise);
        if (this.countRstFrameErrorCode(errorCode)) {
            long currentNano = this.ticker.nanoTime();
            if (currentNano - this.lastRstFrameNano >= this.nanosPerWindow) {
                this.lastRstFrameNano = currentNano;
                this.sendRstInWindow = 1;
            } else {
                ++this.sendRstInWindow;
                if (this.sendRstInWindow > this.maxRstFramesPerWindow) {
                    Http2Exception exception = Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Maximum number %d of RST frames frames reached within %d seconds", this.maxRstFramesPerWindow, TimeUnit.NANOSECONDS.toSeconds(this.nanosPerWindow));
                    logger.debug("{} Maximum number {} of RST frames reached within {} seconds, closing connection with {} error", new Object[]{ctx.channel(), this.maxRstFramesPerWindow, TimeUnit.NANOSECONDS.toSeconds(this.nanosPerWindow), exception.error(), exception});
                    this.lifecycleManager.onError(ctx, true, exception);
                    ctx.close();
                }
            }
        }
        return future;
    }

    private boolean countRstFrameErrorCode(long errorCode) {
        return errorCode != Http2Error.CANCEL.code() && errorCode != Http2Error.NO_ERROR.code();
    }
}

