/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.StringDecode;
import org.apache.spark.sql.catalyst.util.CharsetProvider$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class StringDecode$
implements Serializable {
    public static final StringDecode$ MODULE$ = new StringDecode$();

    public StringDecode apply(Expression bin, Expression charset) {
        return new StringDecode(bin, charset);
    }

    public UTF8String decode(byte[] input, UTF8String charset, boolean legacyCharsets, boolean legacyErrorAction) {
        UTF8String uTF8String;
        String fromCharset = charset.toString();
        CharsetDecoder decoder = CharsetProvider$.MODULE$.newDecoder(fromCharset, legacyCharsets, legacyErrorAction, CharsetProvider$.MODULE$.newDecoder$default$4());
        try {
            CharBuffer cb = decoder.decode(ByteBuffer.wrap(input));
            uTF8String = UTF8String.fromString((String)cb.toString());
        }
        catch (CharacterCodingException characterCodingException) {
            throw QueryExecutionErrors$.MODULE$.malformedCharacterCoding("decode", fromCharset);
        }
        return uTF8String;
    }

    public StringDecode apply(Expression bin, Expression charset, boolean legacyCharsets, boolean legacyErrorAction) {
        return new StringDecode(bin, charset, legacyCharsets, legacyErrorAction);
    }

    public Option<Tuple4<Expression, Expression, Object, Object>> unapply(StringDecode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.bin(), (Object)x$0.charset(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacyCharsets()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.legacyErrorAction())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StringDecode$.class);
    }

    private StringDecode$() {
    }
}

