/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.DataOutputStream;
import java.nio.channels.Channels;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.arrow.ArrowWriter;
import scala.collection.Iterator;

public final class BatchedPythonArrowInput$ {
    public static final BatchedPythonArrowInput$ MODULE$ = new BatchedPythonArrowInput$();

    public int writeSizedBatch(ArrowWriter arrowWriter, ArrowStreamWriter writer, Iterator<InternalRow> rowIter, long maxBytesPerBatch, int maxRecordsPerBatch, VectorUnloader unloader, DataOutputStream dataOut) {
        int numRowsInBatch;
        for (numRowsInBatch = 0; rowIter.hasNext() && numRowsInBatch < maxRecordsPerBatch && BatchedPythonArrowInput$.underBatchSizeLimit$1(maxBytesPerBatch, arrowWriter); ++numRowsInBatch) {
            arrowWriter.write((InternalRow)rowIter.next());
        }
        arrowWriter.finish();
        try (ArrowRecordBatch batch = unloader.getRecordBatch();){
            WriteChannel writeChannel = new WriteChannel(Channels.newChannel(dataOut));
            MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)batch);
        }
        arrowWriter.reset();
        return numRowsInBatch;
    }

    private static final boolean underBatchSizeLimit$1(long maxBytesPerBatch$1, ArrowWriter arrowWriter$1) {
        return maxBytesPerBatch$1 == Integer.MAX_VALUE || (long)arrowWriter$1.sizeInBytes() < maxBytesPerBatch$1;
    }

    private BatchedPythonArrowInput$() {
    }
}

