/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.io.Serializable;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$ = new YarnSparkHadoopUtil$();
    private static final double AM_MEMORY_OVERHEAD_FACTOR = 0.1;
    private static final String ANY_HOST = "*";
    private static final Priority RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
    private static final String envVarNameRegex = "[A-Za-z_][A-Za-z0-9_]*";

    public double AM_MEMORY_OVERHEAD_FACTOR() {
        return AM_MEMORY_OVERHEAD_FACTOR;
    }

    public String ANY_HOST() {
        return ANY_HOST;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return RM_REQUEST_PRIORITY;
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? (String)env.apply((Object)key) + "<CPS>" + value : value;
        env.put((Object)key, (Object)newValue);
    }

    private String envVarNameRegex() {
        return envVarNameRegex;
    }

    public String replaceEnvVars(String unresolvedString, Map<String, String> env, boolean isWindows) {
        String string;
        if (isWindows) {
            Regex windowsPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)(?:\\^\\^|\\^%|%%|%(" + this.envVarNameRegex() + ")%)"));
            string = windowsPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable)m -> {
                String string;
                block5: {
                    String string2 = m.matched();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 1184: {
                            if (!"%%".equals(string2)) break;
                            string = "%";
                            break block5;
                        }
                        case 2951: {
                            if (!"^%".equals(string2)) break;
                            string = "%";
                            break block5;
                        }
                        case 3008: {
                            if (!"^^".equals(string2)) break;
                            string = "^";
                            break block5;
                        }
                    }
                    string = (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "");
                }
                return Regex$.MODULE$.quoteReplacement(string);
            });
        } else {
            Regex unixPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)(?:\\\\\\\\|\\\\\\$|\\$(" + this.envVarNameRegex() + ")|\\$\\{(" + this.envVarNameRegex() + ")})"));
            string = unixPattern.replaceAllIn((CharSequence)unresolvedString, (Function1 & Serializable)m -> {
                String string;
                block4: {
                    String string2 = m.matched();
                    switch (string2 == null ? 0 : string2.hashCode()) {
                        case 2888: {
                            if (!"\\$".equals(string2)) break;
                            string = "$";
                            break block4;
                        }
                        case 2944: {
                            if (!"\\\\".equals(string2)) break;
                            string = "\\";
                            break block4;
                        }
                    }
                    string = string2.startsWith("${") ? (String)env.getOrElse((Object)m.group(2), (Function0 & Serializable)() -> "") : (String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "");
                }
                return Regex$.MODULE$.quoteReplacement(string);
            });
        }
        String osResolvedString = string;
        Regex yarnPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)\\{\\{(" + this.envVarNameRegex() + ")}}"));
        return yarnPattern.replaceAllIn((CharSequence)osResolvedString, (Function1 & Serializable)m -> Regex$.MODULE$.quoteReplacement((String)env.getOrElse((Object)m.group(1), (Function0 & Serializable)() -> "")));
    }

    public boolean replaceEnvVars$default$3() {
        return Utils$.MODULE$.isWindows();
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        if (!javaOpts.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("-XX:OnOutOfMemoryError")))) {
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
                return;
            }
            javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            return;
        }
    }

    public String escapeForShell(String arg) {
        if (arg != null) {
            if (Utils$.MODULE$.isWindows()) {
                return YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
            }
            StringBuilder escaped = new StringBuilder("'");
            StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(arg), (Function1 & Serializable)x0$1 -> YarnSparkHadoopUtil$.$anonfun$escapeForShell$1(escaped, BoxesRunTime.unboxToChar((Object)x0$1)));
            return escaped.append("'").toString();
        }
        return arg;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)(securityMgr.getViewAcls() + " " + securityMgr.getViewAclsGroups())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)(securityMgr.getModifyAcls() + " " + securityMgr.getModifyAclsGroups()))}));
    }

    public ContainerId getContainerId() {
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        return ContainerId.fromString((String)containerIdString);
    }

    public long executorOffHeapMemorySizeAsMb(SparkConf sparkConf, ExecutorResourceRequest execRequest) {
        return Utils$.MODULE$.checkOffHeapEnabled((ReadOnlySparkConf)sparkConf, execRequest.amount());
    }

    public static final /* synthetic */ StringBuilder $anonfun$escapeForShell$1(StringBuilder escaped$1, char x0$1) {
        char c = x0$1;
        switch (c) {
            case '$': {
                return escaped$1.append("\\$");
            }
            case '\"': {
                return escaped$1.append("\\\"");
            }
            case '\'': {
                return escaped$1.append("'\\''");
            }
        }
        return escaped$1.append(c);
    }

    private YarnSparkHadoopUtil$() {
    }
}

