/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.Router;
import com.linecorp.armeria.server.RoutingContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class CompositeRouter<I, O>
implements Router<O> {
    private final List<Router<I>> delegates;
    private final Function<Routed<I>, Routed<O>> resultMapper;

    CompositeRouter(List<Router<I>> delegates, Function<Routed<I>, Routed<O>> resultMapper) {
        this.delegates = Objects.requireNonNull(delegates, "delegates");
        this.resultMapper = Objects.requireNonNull(resultMapper, "resultMapper");
    }

    @Override
    public Routed<O> find(RoutingContext routingCtx) {
        for (Router<I> delegate : this.delegates) {
            Routed<I> result = delegate.find(routingCtx);
            if (!result.isPresent()) continue;
            return this.resultMapper.apply(result);
        }
        return Routed.empty();
    }

    @Override
    public List<Routed<O>> findAll(RoutingContext routingContext) {
        int numDelegates = this.delegates.size();
        switch (numDelegates) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return this.delegates.get(0).findAll(routingContext).stream().map(this.resultMapper).collect(ImmutableList.toImmutableList());
            }
        }
        return this.delegates.stream().flatMap(delegate -> delegate.findAll(routingContext).stream()).map(this.resultMapper).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
        int numDelegates = this.delegates.size();
        switch (numDelegates) {
            case 0: {
                return false;
            }
            case 1: {
                return this.delegates.get(0).registerMetrics(registry, idPrefix);
            }
        }
        boolean registered = false;
        for (int i = 0; i < numDelegates; ++i) {
            MeterIdPrefix delegateIdPrefix = idPrefix.withTags("index", String.valueOf(i));
            if (!this.delegates.get(i).registerMetrics(registry, delegateIdPrefix)) continue;
            registered = true;
        }
        return registered;
    }

    @Override
    public void dump(OutputStream output) {
        this.delegates.forEach(delegate -> delegate.dump(output));
    }
}

