/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retry;

import com.linecorp.armeria.client.retry.AbstractBackoff;
import com.linecorp.armeria.client.retry.Backoff;
import com.linecorp.armeria.client.retry.BackoffWrapper;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

final class AttemptLimitingBackoff
extends BackoffWrapper {
    private final int maxAttempts;

    AttemptLimitingBackoff(Backoff backoff, int maxAttempts) {
        super(backoff);
        Preconditions.checkArgument(maxAttempts > 0, "maxAttempts: %s (expected: > 0)", maxAttempts);
        this.maxAttempts = maxAttempts;
    }

    @Override
    public long nextDelayMillis(int numAttemptsSoFar) {
        AbstractBackoff.validateNumAttemptsSoFar(numAttemptsSoFar);
        if (numAttemptsSoFar >= this.maxAttempts) {
            return -1L;
        }
        return super.nextDelayMillis(numAttemptsSoFar);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.unwrap()).add("maxAttempts", this.maxAttempts).toString();
    }
}

