/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;

public class SearchableTracesTagsWatcher
extends ConfigChangeWatcher {
    private AtomicReference<Set<String>> searchableTags = new AtomicReference(new HashSet());
    private final String initialSettingsString;
    private volatile String dynamicSettingsString;

    public SearchableTracesTagsWatcher(String config, ModuleProvider provider) {
        super("core", provider, "searchableTracesTags");
        this.initialSettingsString = config;
        this.activeSetting(config);
    }

    private void activeSetting(String config) {
        String[] settings;
        HashSet<String> tags = new HashSet<String>();
        for (String setting : settings = config.split(",")) {
            tags.add(setting);
        }
        this.searchableTags.set(tags);
    }

    public Set<String> getSearchableTags() {
        return this.searchableTags.get();
    }

    public void notify(ConfigChangeWatcher.ConfigChangeEvent value) {
        if (ConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.dynamicSettingsString = null;
            this.activeSetting(this.initialSettingsString);
        } else {
            this.dynamicSettingsString = value.getNewValue();
            this.activeSetting(value.getNewValue());
        }
    }

    public String value() {
        return this.dynamicSettingsString;
    }
}

