/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.spanattach;

import com.google.protobuf.ByteString;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.model.BanyanDBTrace;
import org.apache.skywalking.oap.server.core.storage.query.proto.Source;
import org.apache.skywalking.oap.server.core.storage.query.proto.SpanWrapper;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=65, name="SpanAttachedEvent")
@Stream(name="span_attached_event_record", scopeId=65, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="timestamp")
@BanyanDB.Trace.TraceIdColumn(value="related_trace_id")
@BanyanDB.Trace.SpanIdColumn(value="id")
@BanyanDB.Group(traceGroup=BanyanDB.TraceGroup.ZIPKIN_TRACE)
public class SpanAttachedEventRecord
extends Record
implements BanyanDBTrace,
BanyanDBTrace.MergeTable {
    public static final String INDEX_NAME = "span_attached_event_record";
    public static final String START_TIME_SECOND = "start_time_second";
    public static final String START_TIME_NANOS = "start_time_nanos";
    public static final String EVENT = "event";
    public static final String END_TIME_SECOND = "end_time_second";
    public static final String END_TIME_NANOS = "end_time_nanos";
    public static final String TRACE_REF_TYPE = "trace_ref_type";
    public static final String RELATED_TRACE_ID = "related_trace_id";
    public static final String TRACE_SEGMENT_ID = "trace_segment_id";
    public static final String TRACE_SPAN_ID = "trace_span_id";
    public static final String DATA_BINARY = "data_binary";
    public static final String TIMESTAMP = "timestamp";
    @ElasticSearch.EnableDocValues
    @Column(name="start_time_second")
    private long startTimeSecond;
    @ElasticSearch.EnableDocValues
    @Column(name="start_time_nanos")
    private int startTimeNanos;
    @Column(name="event")
    private String event;
    @Column(name="end_time_second")
    private long endTimeSecond;
    @Column(name="end_time_nanos")
    private int endTimeNanos;
    @Column(name="trace_ref_type")
    private int traceRefType;
    @Column(name="related_trace_id")
    private String relatedTraceId;
    @Column(name="trace_segment_id")
    private String traceSegmentId;
    @Column(name="trace_span_id")
    private String traceSpanId;
    @Column(name="data_binary", storageOnly=true)
    private byte[] dataBinary;
    @ElasticSearch.EnableDocValues
    @Column(name="timestamp")
    private long timestamp;

    @Override
    public StorageID id() {
        return new StorageID().append(TRACE_SEGMENT_ID, this.traceSegmentId).append(START_TIME_SECOND, this.startTimeSecond).append(START_TIME_NANOS, this.startTimeNanos).append(EVENT, this.event);
    }

    @Override
    public SpanWrapper getSpanWrapper() {
        SpanWrapper.Builder builder = SpanWrapper.newBuilder();
        builder.setSpan(ByteString.copyFrom((byte[])this.dataBinary));
        builder.setSource(Source.ZIPKIN_EVENT);
        return builder.build();
    }

    @Override
    public String getMergeTableName() {
        return "zipkin_span";
    }

    @Override
    public String getMergeTraceIdColumnName() {
        return "trace_id";
    }

    @Override
    public String getTraceIdColumnValue() {
        return this.relatedTraceId;
    }

    @Override
    public String getMergeTimestampColumnName() {
        return "timestamp_millis";
    }

    @Override
    public long getTimestampColumnValue() {
        return this.timestamp;
    }

    @Override
    public String getMergeSpanIdColumnName() {
        return "span_id";
    }

    @Override
    public String getSpanIdColumnValue() {
        return this.id().build();
    }

    @Generated
    public void setStartTimeSecond(long startTimeSecond) {
        this.startTimeSecond = startTimeSecond;
    }

    @Generated
    public void setStartTimeNanos(int startTimeNanos) {
        this.startTimeNanos = startTimeNanos;
    }

    @Generated
    public void setEvent(String event) {
        this.event = event;
    }

    @Generated
    public void setEndTimeSecond(long endTimeSecond) {
        this.endTimeSecond = endTimeSecond;
    }

    @Generated
    public void setEndTimeNanos(int endTimeNanos) {
        this.endTimeNanos = endTimeNanos;
    }

    @Generated
    public void setTraceRefType(int traceRefType) {
        this.traceRefType = traceRefType;
    }

    @Generated
    public void setRelatedTraceId(String relatedTraceId) {
        this.relatedTraceId = relatedTraceId;
    }

    @Generated
    public void setTraceSegmentId(String traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    public void setTraceSpanId(String traceSpanId) {
        this.traceSpanId = traceSpanId;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public long getStartTimeSecond() {
        return this.startTimeSecond;
    }

    @Generated
    public int getStartTimeNanos() {
        return this.startTimeNanos;
    }

    @Generated
    public String getEvent() {
        return this.event;
    }

    @Generated
    public long getEndTimeSecond() {
        return this.endTimeSecond;
    }

    @Generated
    public int getEndTimeNanos() {
        return this.endTimeNanos;
    }

    @Generated
    public int getTraceRefType() {
        return this.traceRefType;
    }

    @Generated
    public String getRelatedTraceId() {
        return this.relatedTraceId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public String getTraceSpanId() {
        return this.traceSpanId;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    public static class Builder
    implements StorageBuilder<SpanAttachedEventRecord> {
        @Override
        public SpanAttachedEventRecord storage2Entity(Convert2Entity converter) {
            SpanAttachedEventRecord record = new SpanAttachedEventRecord();
            record.setStartTimeSecond(((Number)converter.get(SpanAttachedEventRecord.START_TIME_SECOND)).longValue());
            record.setStartTimeNanos(((Number)converter.get(SpanAttachedEventRecord.START_TIME_NANOS)).intValue());
            record.setEvent((String)converter.get(SpanAttachedEventRecord.EVENT));
            record.setEndTimeSecond(((Number)converter.get(SpanAttachedEventRecord.END_TIME_SECOND)).longValue());
            record.setEndTimeNanos(((Number)converter.get(SpanAttachedEventRecord.END_TIME_NANOS)).intValue());
            record.setTraceRefType(((Number)converter.get(SpanAttachedEventRecord.TRACE_REF_TYPE)).intValue());
            record.setRelatedTraceId((String)converter.get(SpanAttachedEventRecord.RELATED_TRACE_ID));
            record.setTraceSegmentId((String)converter.get(SpanAttachedEventRecord.TRACE_SEGMENT_ID));
            record.setTraceSpanId((String)converter.get(SpanAttachedEventRecord.TRACE_SPAN_ID));
            record.setDataBinary(converter.getBytes(SpanAttachedEventRecord.DATA_BINARY));
            record.setTimestamp(((Number)converter.get(SpanAttachedEventRecord.TIMESTAMP)).longValue());
            return record;
        }

        @Override
        public void entity2Storage(SpanAttachedEventRecord entity, Convert2Storage converter) {
            converter.accept(SpanAttachedEventRecord.START_TIME_SECOND, entity.getStartTimeSecond());
            converter.accept(SpanAttachedEventRecord.START_TIME_NANOS, entity.getStartTimeNanos());
            converter.accept(SpanAttachedEventRecord.EVENT, entity.getEvent());
            converter.accept(SpanAttachedEventRecord.END_TIME_SECOND, entity.getEndTimeSecond());
            converter.accept(SpanAttachedEventRecord.END_TIME_NANOS, entity.getEndTimeNanos());
            converter.accept(SpanAttachedEventRecord.TRACE_REF_TYPE, entity.getTraceRefType());
            converter.accept(SpanAttachedEventRecord.RELATED_TRACE_ID, entity.getRelatedTraceId());
            converter.accept(SpanAttachedEventRecord.TRACE_SEGMENT_ID, entity.getTraceSegmentId());
            converter.accept(SpanAttachedEventRecord.TRACE_SPAN_ID, entity.getTraceSpanId());
            converter.accept(SpanAttachedEventRecord.DATA_BINARY, entity.getDataBinary());
            converter.accept(SpanAttachedEventRecord.TIMESTAMP, entity.getTimestamp());
        }
    }
}

