/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.ZabbixErrorProtocolException;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixRequest;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.protocol.bean.ZabbixRequestJsonDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZabbixProtocolDecoder
extends ByteToMessageDecoder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZabbixProtocolDecoder.class);
    private static final int HEADER_LEN = 9;
    private static final byte[] PROTOCOL = new byte[]{90, 66, 88, 68};
    private final Gson requestParser = new GsonBuilder().registerTypeAdapter(ZabbixRequest.class, (Object)new ZabbixRequestJsonDeserializer()).create();

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            String payload = this.decodeToPayload(channelHandlerContext, byteBuf);
            if (payload == null) {
                return;
            }
            ZabbixRequest request = (ZabbixRequest)this.requestParser.fromJson(payload, ZabbixRequest.class);
            list.add(request);
        }
        catch (Exception e) {
            this.errorProtocol(channelHandlerContext, byteBuf, "Parsing zabbix request data error", e);
        }
    }

    public String decodeToPayload(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws InterruptedException, ZabbixErrorProtocolException {
        int readable = byteBuf.readableBytes();
        int baseIndex = byteBuf.readerIndex();
        if (readable < 9) {
            byteBuf.readerIndex(baseIndex);
            return null;
        }
        ByteBuf headerBuf = byteBuf.readSlice(9);
        if (headerBuf.getByte(0) != PROTOCOL[0] || headerBuf.getByte(1) != PROTOCOL[1] || headerBuf.getByte(2) != PROTOCOL[2] || headerBuf.getByte(3) != PROTOCOL[3]) {
            throw new ZabbixErrorProtocolException("header is not right");
        }
        if (headerBuf.getByte(4) != 1) {
            throw new ZabbixErrorProtocolException("header flags only support communications protocol");
        }
        int dataLength = headerBuf.getByte(5) & 0xFF | (headerBuf.getByte(6) & 0xFF) << 8 | (headerBuf.getByte(7) & 0xFF) << 16 | (headerBuf.getByte(8) & 0xFF) << 24;
        int totalLength = 9 + dataLength + 4;
        if (readable < totalLength) {
            byteBuf.readerIndex(baseIndex);
            return null;
        }
        if (dataLength <= 0) {
            throw new ZabbixErrorProtocolException("content could not be empty");
        }
        byteBuf.skipBytes(4);
        ByteBuf payload = byteBuf.readSlice(dataLength);
        return payload.toString(Charsets.UTF_8);
    }

    protected void errorProtocol(ChannelHandlerContext context, ByteBuf byteBuf, String reason, Throwable ex) throws InterruptedException {
        log.warn("Receive message is not Zabbix protocol, reason: {}", (Object)reason, (Object)ex);
        byteBuf.skipBytes(byteBuf.readableBytes());
        context.close();
    }
}

