/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.HttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import io.netty.channel.ChannelFuture;

interface ServerHttpObjectEncoder
extends HttpObjectEncoder {
    default public ChannelFuture writeHeaders(int id, int streamId, ResponseHeaders headers, boolean endStream, HttpMethod method) {
        return this.writeHeaders(id, streamId, headers, endStream, true, method);
    }

    default public ChannelFuture writeHeaders(int id, int streamId, ResponseHeaders headers, boolean endStream, boolean isTrailersEmpty, HttpMethod method) {
        if (!1.$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        if (this.isClosed()) {
            return this.newClosedSessionFuture();
        }
        return this.doWriteHeaders(id, streamId, headers, endStream, isTrailersEmpty, method);
    }

    public ChannelFuture doWriteHeaders(int var1, int var2, ResponseHeaders var3, boolean var4, boolean var5, HttpMethod var6);

    public boolean isResponseHeadersSent(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public ChannelFuture writeErrorResponse(int id, int streamId, ServiceConfig serviceConfig, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        AggregatedHttpResponse res = serviceConfig.server().config().errorHandler().onProtocolViolation(serviceConfig, headers, status, message, cause);
        if (!1.$assertionsDisabled && res == null) {
            throw new AssertionError();
        }
        HttpData content = res.content();
        boolean transferredContent = false;
        HttpMethod method = headers != null ? headers.method() : HttpMethod.UNKNOWN;
        try {
            ResponseHeaders resHeaders = res.headers();
            HttpHeaders resTrailers = res.trailers();
            if (resTrailers.isEmpty()) {
                if (content.isEmpty()) {
                    ChannelFuture channelFuture = this.writeHeaders(id, streamId, resHeaders, true, method);
                    return channelFuture;
                }
                this.writeHeaders(id, streamId, resHeaders, false, method);
                transferredContent = true;
                ChannelFuture channelFuture = this.writeData(id, streamId, content, true);
                return channelFuture;
            }
            this.writeHeaders(id, streamId, resHeaders, false, method);
            if (!content.isEmpty()) {
                transferredContent = true;
                this.writeData(id, streamId, content, false);
            }
            ChannelFuture channelFuture = this.writeTrailers(id, streamId, resTrailers);
            return channelFuture;
        }
        finally {
            if (!transferredContent) {
                content.close();
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

