/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.util.CertificateUtil;
import com.linecorp.armeria.internal.common.util.SelfSignedCertificate;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.File;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;

@UnstableApi
public final class TlsKeyPair {
    private final PrivateKey privateKey;
    private final List<X509Certificate> certificateChain;

    public static TlsKeyPair of(InputStream keyInputStream, InputStream certificateChainInputStream) {
        return TlsKeyPair.of(keyInputStream, null, certificateChainInputStream);
    }

    public static TlsKeyPair of(InputStream keyInputStream, @Nullable String keyPassword, InputStream certificateChainInputStream) {
        Objects.requireNonNull(keyInputStream, "keyInputStream");
        Objects.requireNonNull(certificateChainInputStream, "certificateChainInputStream");
        try {
            List<X509Certificate> certs = CertificateUtil.toX509Certificates(certificateChainInputStream);
            PrivateKey key = CertificateUtil.toPrivateKey(keyInputStream, keyPassword);
            return TlsKeyPair.of(key, certs);
        }
        catch (KeyException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TlsKeyPair of(File keyFile, File certificateChainFile) {
        return TlsKeyPair.of(keyFile, null, certificateChainFile);
    }

    public static TlsKeyPair of(File keyFile, @Nullable String keyPassword, File certificateChainFile) {
        Objects.requireNonNull(keyFile, "keyFile");
        Objects.requireNonNull(certificateChainFile, "certificateChainFile");
        try {
            List<X509Certificate> certs = CertificateUtil.toX509Certificates(certificateChainFile);
            PrivateKey key = CertificateUtil.toPrivateKey(keyFile, keyPassword);
            return TlsKeyPair.of(key, certs);
        }
        catch (KeyException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TlsKeyPair of(PrivateKey key, X509Certificate ... certificateChain) {
        Objects.requireNonNull(certificateChain, "certificateChain");
        return TlsKeyPair.of(key, ImmutableList.copyOf(certificateChain));
    }

    public static TlsKeyPair of(PrivateKey key, Iterable<? extends X509Certificate> certificateChain) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(certificateChain, "certificateChain");
        return new TlsKeyPair(key, ImmutableList.copyOf(certificateChain));
    }

    public static TlsKeyPair ofSelfSigned(String hostname) {
        Objects.requireNonNull(hostname, "hostname");
        try {
            SelfSignedCertificate ssc = new SelfSignedCertificate(hostname);
            return TlsKeyPair.of(ssc.key(), ssc.cert());
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Failed to create a self-signed certificate for " + hostname, e);
        }
    }

    public static TlsKeyPair ofSelfSigned() {
        return TlsKeyPair.ofSelfSigned(SystemInfo.hostname());
    }

    private TlsKeyPair(PrivateKey privateKey, List<X509Certificate> certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
    }

    public PrivateKey privateKey() {
        return this.privateKey;
    }

    public List<X509Certificate> certificateChain() {
        return this.certificateChain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TlsKeyPair)) {
            return false;
        }
        TlsKeyPair that = (TlsKeyPair)o;
        return this.privateKey.equals(that.privateKey) && this.certificateChain.equals(that.certificateChain);
    }

    public int hashCode() {
        return this.privateKey.hashCode() * 31 + this.certificateChain.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("privateKey", "****").add("certificateChain", this.certificateChain).toString();
    }
}

