/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.SimpleDecoratingClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerDecision;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRule;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

public abstract class AbstractCircuitBreakerClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    @Nullable
    private final CircuitBreakerRule rule;
    @Nullable
    private final CircuitBreakerRule fromRuleWithContent;
    @Nullable
    private final CircuitBreakerRuleWithContent<O> ruleWithContent;
    @Nullable
    private final BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback;
    private final CircuitBreakerClientHandler handler;

    AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerClientHandler handler, CircuitBreakerRule rule, @Nullable BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback) {
        this(delegate, handler, Objects.requireNonNull(rule, "rule"), null, fallback);
    }

    AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerClientHandler handler, CircuitBreakerRuleWithContent<O> ruleWithContent, @Nullable BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback) {
        this(delegate, handler, null, Objects.requireNonNull(ruleWithContent, "ruleWithContent"), fallback);
    }

    private AbstractCircuitBreakerClient(Client<I, O> delegate, CircuitBreakerClientHandler handler, @Nullable CircuitBreakerRule rule, @Nullable CircuitBreakerRuleWithContent<O> ruleWithContent, @Nullable BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback) {
        super(delegate);
        this.handler = Objects.requireNonNull(handler, "handler");
        this.rule = rule;
        this.ruleWithContent = ruleWithContent;
        this.fromRuleWithContent = ruleWithContent != null ? CircuitBreakerRuleUtil.fromCircuitBreakerRuleWithContent(ruleWithContent) : null;
        this.fallback = fallback;
    }

    final CircuitBreakerRule rule() {
        Preconditions.checkState(this.rule != null, "rule is not set.");
        return this.rule;
    }

    final CircuitBreakerRuleWithContent<O> ruleWithContent() {
        Preconditions.checkState(this.ruleWithContent != null, "ruleWithContent is not set.");
        return this.ruleWithContent;
    }

    final CircuitBreakerRule fromRuleWithContent() {
        Preconditions.checkState(this.fromRuleWithContent != null, "fromRuleWithContent is not set.");
        return this.fromRuleWithContent;
    }

    final CircuitBreakerClientHandler handler() {
        return this.handler;
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        try {
            CircuitBreakerCallback callback = this.handler.tryRequest(ctx, (Request)req);
            if (callback == null) {
                return ((Client)this.unwrap()).execute(ctx, req);
            }
            return this.doExecute(ctx, req, callback);
        }
        catch (Exception ex) {
            if (this.fallback != null && this.handler().isCircuitBreakerException(ex)) {
                Response res = (Response)this.fallback.apply(ctx, req);
                return (O)Objects.requireNonNull(res, "fallback.apply() returned null.");
            }
            throw ex;
        }
    }

    protected abstract O doExecute(ClientRequestContext var1, I var2, CircuitBreakerCallback var3) throws Exception;

    static void reportSuccessOrFailure(CircuitBreakerCallback callback, CompletionStage<@Nullable CircuitBreakerDecision> future, ClientRequestContext ctx, @Nullable Throwable throwable) {
        future.handle((decision, unused) -> {
            if (decision != null) {
                if (decision == CircuitBreakerDecision.success() || decision == CircuitBreakerDecision.next()) {
                    callback.onSuccess(ctx);
                } else if (decision == CircuitBreakerDecision.failure()) {
                    callback.onFailure(ctx, throwable);
                }
            }
            return null;
        }).exceptionally(CompletionActions::log);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("rule", this.rule).add("fromRuleWithContent", this.fromRuleWithContent).add("ruleWithContent", this.ruleWithContent).add("handler", this.handler).toString();
    }
}

