/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener;

import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppWebInteractionPerf;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.decorators.BrowserWebInteractionPerfDataDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.performance.listener.PerfDataListenerFactory;

public class BrowserWebInteractionPerfDataAnalysisListener
implements PerfDataAnalysisListener<BrowserWebInteractionPerfDataDecorator> {
    private final SourceReceiver sourceReceiver;
    private final NamingControl namingControl;
    private BrowserAppWebInteractionPerf browserAppWebInteractionPerf;

    public BrowserWebInteractionPerfDataAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.namingControl = namingControl;
    }

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.browserAppWebInteractionPerf);
    }

    @Override
    public void parse(BrowserWebInteractionPerfDataDecorator decorator) {
        this.browserAppWebInteractionPerf = new BrowserAppWebInteractionPerf();
        this.browserAppWebInteractionPerf.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)decorator.getTime()));
        this.browserAppWebInteractionPerf.setServiceName(this.namingControl.formatServiceName(decorator.getService()));
        this.browserAppWebInteractionPerf.setPath(this.namingControl.formatEndpointName(this.browserAppWebInteractionPerf.getServiceName(), decorator.getPagePath()));
        this.browserAppWebInteractionPerf.setInpTime(decorator.getInpTime());
    }

    public static class Factory
    implements PerfDataListenerFactory<BrowserWebInteractionPerfDataDecorator> {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public PerfDataAnalysisListener<BrowserWebInteractionPerfDataDecorator> create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new BrowserWebInteractionPerfDataAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

