/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.tracing.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.jms.tracing.JmsTracer;
import org.apache.qpid.jms.tracing.TraceableMessage;

public class OpenTracingTracer
implements JmsTracer {
    static final String REDELIVERIES_EXCEEDED = "redeliveries-exceeded";
    static final String MESSAGE_EXPIRED = "message-expired";
    static final String SEND_SPAN_NAME = "amqp-delivery-send";
    static final String RECEIVE_SPAN_NAME = "receive";
    static final String ONMESSAGE_SPAN_NAME = "onMessage";
    static final String DELIVERY_SETTLED = "delivery settled";
    static final String STATE = "state";
    static final String COMPONENT = "qpid-jms";
    static final Object ERROR_EVENT = "error";
    static final String SEND_SPAN_CONTEXT_KEY = "sendSpan";
    static final String ARRIVING_SPAN_CTX_CONTEXT_KEY = "arrivingContext";
    static final String DELIVERY_SPAN_CONTEXT_KEY = "deliverySpan";
    static final String ONMESSAGE_SCOPE_CONTEXT_KEY = "onMessageScope";
    static final String ANNOTATION_KEY = "x-opt-qpid-tracestate";
    private Tracer tracer;
    private boolean closeUnderlyingTracer;

    OpenTracingTracer(Tracer tracer, boolean closeUnderlyingTracer) {
        this.tracer = tracer;
        this.closeUnderlyingTracer = closeUnderlyingTracer;
    }

    @Override
    public void initSend(TraceableMessage message, String address) {
        Span span = this.tracer.buildSpan(SEND_SPAN_NAME).withTag((Tag)Tags.SPAN_KIND, (Object)"producer").withTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)address).withTag((Tag)Tags.COMPONENT, (Object)COMPONENT).start();
        LazyTextMapInject carrier = new LazyTextMapInject();
        this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)carrier);
        if (carrier.getInjectMap() != null) {
            message.setTracingAnnotation(ANNOTATION_KEY, carrier.getInjectMap());
        } else {
            message.removeTracingAnnotation(ANNOTATION_KEY);
        }
        message.setTracingContext(SEND_SPAN_CONTEXT_KEY, span);
    }

    @Override
    public void completeSend(TraceableMessage message, String outcome) {
        Object cachedSpan = message.getTracingContext(SEND_SPAN_CONTEXT_KEY);
        if (cachedSpan != null) {
            Span span = (Span)cachedSpan;
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("event", DELIVERY_SETTLED);
            fields.put(STATE, outcome == null ? "null" : outcome);
            span.log(fields);
            span.finish();
        }
    }

    private SpanContext extract(TraceableMessage message) {
        SpanContext spanContext = null;
        Map headers = (Map)message.getTracingAnnotation(ANNOTATION_KEY);
        if (headers != null && !headers.isEmpty()) {
            spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(headers));
        }
        if (spanContext != null) {
            message.setTracingContext(ARRIVING_SPAN_CTX_CONTEXT_KEY, spanContext);
        }
        return spanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncReceive(TraceableMessage message, String address, JmsTracer.DeliveryOutcome outcome) {
        SpanContext context = this.extract(message);
        Span span = this.tracer.buildSpan(RECEIVE_SPAN_NAME).asChildOf(context).withTag((Tag)Tags.SPAN_KIND, (Object)"consumer").withTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)address).withTag((Tag)Tags.COMPONENT, (Object)COMPONENT).start();
        try {
            this.addDeliveryLogIfNeeded(outcome, span);
        }
        finally {
            span.finish();
        }
        message.setTracingContext(DELIVERY_SPAN_CONTEXT_KEY, span);
    }

    private void addDeliveryLogIfNeeded(JmsTracer.DeliveryOutcome outcome, Span span) {
        HashMap<String, String> fields = null;
        if (outcome == JmsTracer.DeliveryOutcome.EXPIRED) {
            fields = new HashMap<String, String>();
            fields.put("event", MESSAGE_EXPIRED);
        } else if (outcome == JmsTracer.DeliveryOutcome.REDELIVERIES_EXCEEDED) {
            fields = new HashMap();
            fields.put("event", REDELIVERIES_EXCEEDED);
        }
        if (fields != null) {
            span.log(fields);
        }
    }

    @Override
    public void asyncDeliveryInit(TraceableMessage message, String address) {
        SpanContext context = this.extract(message);
        Span span = this.tracer.buildSpan(ONMESSAGE_SPAN_NAME).ignoreActiveSpan().asChildOf(context).withTag((Tag)Tags.SPAN_KIND, (Object)"consumer").withTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)address).withTag((Tag)Tags.COMPONENT, (Object)COMPONENT).start();
        message.setTracingContext(DELIVERY_SPAN_CONTEXT_KEY, span);
        Scope scope = this.tracer.activateSpan(span);
        message.setTracingContext(ONMESSAGE_SCOPE_CONTEXT_KEY, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDeliveryComplete(TraceableMessage message, JmsTracer.DeliveryOutcome outcome, Throwable throwable) {
        Scope scope = (Scope)message.removeTracingContext(ONMESSAGE_SCOPE_CONTEXT_KEY);
        try {
            if (scope != null) {
                scope.close();
            }
        }
        finally {
            Span span = (Span)message.getTracingContext(DELIVERY_SPAN_CONTEXT_KEY);
            if (span != null) {
                try {
                    if (throwable != null) {
                        span.setTag((Tag)Tags.ERROR, (Object)true);
                        HashMap<String, Object> fields = new HashMap<String, Object>();
                        fields.put("event", ERROR_EVENT);
                        fields.put("error.object", throwable);
                        fields.put("message", "Application error, exception thrown from onMessage.");
                        span.log(fields);
                    } else {
                        this.addDeliveryLogIfNeeded(outcome, span);
                    }
                }
                finally {
                    span.finish();
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.closeUnderlyingTracer) {
            this.tracer.close();
        }
    }

    private static class LazyTextMapInject
    implements TextMap {
        private Map<String, String> injectMap = null;

        private LazyTextMapInject() {
        }

        public void put(String key, String value) {
            if (this.injectMap == null) {
                this.injectMap = new HashMap<String, String>();
            }
            this.injectMap.put(key, value);
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            throw new UnsupportedOperationException();
        }

        Map<String, String> getInjectMap() {
            return this.injectMap;
        }
    }
}

