/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContext;
import org.apache.qpid.server.query.engine.evaluator.EvaluationContextHolder;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.converter.ImplicitConverter;
import org.apache.qpid.server.query.engine.parsing.converter.NumberConverter;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.factory.CollectorFactory;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectExpression.class);

    public <T, R> Stream<Map<String, R>> evaluate(SelectExpression<T, R> selectExpression) {
        Stream<T> stream;
        LOGGER.debug("Executing select '{}'", selectExpression);
        EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
        boolean addAlias = selectExpression.getFrom() != null && !Objects.equals(selectExpression.getFrom().getAlias(), selectExpression.getFrom().toString());
        Stream<Object> stream2 = stream = selectExpression.getFrom() == null ? Stream.empty() : selectExpression.getFrom().get().peek(item -> {
            if (addAlias) {
                ctx.putAlias(selectExpression.getFrom().getAlias(), new ConstantExpression(item));
            }
        });
        if (selectExpression.getWhere() != null) {
            stream = stream.filter(selectExpression.getWhere());
        }
        return this.mapProjections(selectExpression, stream);
    }

    private <T, R> Stream<Map<String, R>> mapProjections(SelectExpression<T, R> selectExpression, Stream<T> stream) {
        Stream<Map<String, R>> mapped;
        EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
        List<String> projectionAliases = selectExpression.getProjections().stream().map(ProjectionExpression::getAlias).collect(Collectors.toList());
        if (!selectExpression.isSelectAll() && selectExpression.getParent() == null) {
            List orderItems = (List)ctx.get("query.ordering");
            ArrayList additionalProjections = orderItems == null ? new ArrayList() : orderItems.stream().filter(item -> !item.isAliasOrdinal()).filter(item -> !projectionAliases.contains(item.getAlias())).map(item -> new ProjectionExpression(item.getAlias(), item.getExpression(), selectExpression.getOrdinal())).collect(Collectors.toList());
            projectionAliases.addAll(additionalProjections.stream().map(ProjectionExpression::getAlias).collect(Collectors.toList()));
            selectExpression.getProjections().addAll(additionalProjections);
            ctx.put("query.items.for.removal", additionalProjections);
        }
        ArrayList projections = new ArrayList(selectExpression.getProjections());
        if (selectExpression.hasAggregationItems() && selectExpression.getGroupBy().isEmpty()) {
            return Stream.of(this.aggregate(selectExpression, stream));
        }
        if (!selectExpression.getGroupBy().isEmpty()) {
            return Stream.of(this.groupBy(selectExpression, stream));
        }
        List<String> aliases = selectExpression.isSelectAll() ? selectExpression.getFrom().getFieldNames() : projectionAliases;
        ArrayList values = selectExpression.isSelectAll() ? selectExpression.getFrom().getProjections(aliases, selectExpression) : projections;
        Stream<Map<String, Object>> stream2 = mapped = selectExpression.getFrom() == null ? IntStream.range(0, projections.size()).mapToObj(item -> this.toMap(aliases, values, null)) : stream.map(item -> this.toMap(aliases, values, item));
        if (selectExpression.isDistinct()) {
            mapped = mapped.distinct();
        }
        return mapped;
    }

    private <T, R> Map<String, R> toMap(List<String> aliases, List<ProjectionExpression<T, R>> projections, T item) {
        return IntStream.range(0, projections.size()).boxed().collect(LinkedHashMap::new, (map, index) -> map.put((String)aliases.get((int)index), ImplicitConverter.convert(((ProjectionExpression)projections.get((int)index)).apply(item))), HashMap::putAll);
    }

    private <T, R> Map<String, R> aggregate(SelectExpression<T, R> selectExpression, Stream<T> stream) {
        List items = stream.collect(Collectors.toList());
        if (selectExpression.getHaving() != null) {
            selectExpression.getHaving().applyAggregation(selectExpression, items);
            items = items.stream().filter(selectExpression.getHaving()).collect(Collectors.toList());
        }
        List filtered = items;
        return IntStream.range(0, selectExpression.getProjections().size()).boxed().map(index -> selectExpression.getProjections().get((int)index)).collect(LinkedHashMap::new, (map, projection) -> map.put(projection.getAlias(), projection.applyAggregation(selectExpression, filtered)), HashMap::putAll);
    }

    private <T, A, R> Map<String, R> groupBy(SelectExpression<T, R> selectExpression, Stream<T> stream) {
        List items = stream.collect(Collectors.toList());
        List<ProjectionExpression<T, R>> groupByItems = selectExpression.getGroupBy();
        List<ProjectionExpression<T, R>> aggregationItems = selectExpression.getAggregationItems();
        EvaluationContext ctx = EvaluationContextHolder.getEvaluationContext();
        selectExpression.getProjections().forEach(item -> ctx.putAlias(item.getAlias(), item));
        if (selectExpression.getHaving() != null) {
            selectExpression.getHaving().applyAggregation(selectExpression, items);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (ProjectionExpression<T, R> projectionExpression : aggregationItems) {
            for (AbstractAggregationExpression aggregation : projectionExpression.getAggregations()) {
                Expression sourceExpression = aggregation.getSource();
                CollectorType collectorType = aggregation.getCollectorType();
                Collector collector = CollectorFactory.collector(collectorType).apply(sourceExpression);
                for (int i = groupByItems.size() - 1; i >= 0; --i) {
                    collector = Collectors.groupingBy((Function)groupByItems.get(i), collector);
                    collector = Collectors.collectingAndThen(collector, object -> {
                        if (object instanceof Map) {
                            for (Map.Entry entry : ((Map)object).entrySet()) {
                                if (!(entry.getValue() instanceof Number)) continue;
                                aggregation.setValue(entry.getValue());
                                entry.setValue(NumberConverter.narrow((Number)projection.apply(null)));
                            }
                        }
                        return object;
                    });
                    if (selectExpression.getHaving() == null) continue;
                    collector = CollectorFactory.filtering(selectExpression.getHaving(), collector);
                }
                result.put(projectionExpression.getAlias(), items.stream().collect(collector));
            }
        }
        if (selectExpression.getHaving() != null) {
            for (Map.Entry entry : result.entrySet()) {
                selectExpression.getHaving().filter((Map)entry.getValue());
            }
        }
        ctx.put("query.aggregated.result", Boolean.TRUE);
        return result;
    }
}

