/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.preferences;

import java.util.Map;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.store.preferences.JsonFilePreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreFactoryService;

@PluggableService
public class JsonFilePreferenceStoreFactoryService
implements PreferenceStoreFactoryService {
    private static final String TYPE = "JSON";
    private static final String PATH = "path";

    @Override
    public PreferenceStore createInstance(ConfiguredObject<?> parent, Map<String, Object> preferenceStoreAttributes) {
        Object path = preferenceStoreAttributes.get(PATH);
        if (path == null || !(path instanceof String)) {
            throw new IllegalConfigurationException("JsonFilePreferenceStore requires path");
        }
        String posixFilePermissions = parent.getContextValue(String.class, "qpid.default_posix_file_permissions");
        return new JsonFilePreferenceStore((String)path, posixFilePermissions);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

