/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;

public class AuthenticationResult {
    private final AuthenticationStatus _status;
    private final byte[] _challenge;
    private final Exception _cause;
    private final Set<Principal> _principals = new HashSet<Principal>();
    private final Principal _mainPrincipal;

    public AuthenticationResult(AuthenticationStatus status) {
        this(null, status, null);
    }

    public AuthenticationResult(Principal mainPrincipal) {
        this(mainPrincipal, null);
    }

    public AuthenticationResult(Principal mainPrincipal, byte[] challenge) {
        this(mainPrincipal, Set.of(), challenge);
    }

    public AuthenticationResult(Principal mainPrincipal, Set<Principal> otherPrincipals, byte[] challenge) {
        AuthenticatedPrincipal specialQpidAuthenticatedPrincipal = new AuthenticatedPrincipal(mainPrincipal);
        this._principals.addAll(otherPrincipals);
        this._principals.remove(mainPrincipal);
        this._principals.add(specialQpidAuthenticatedPrincipal);
        this._mainPrincipal = mainPrincipal;
        this._status = AuthenticationStatus.SUCCESS;
        this._challenge = challenge;
        this._cause = null;
    }

    public AuthenticationResult(byte[] challenge, AuthenticationStatus status) {
        this._challenge = challenge;
        this._status = status;
        this._cause = null;
        this._mainPrincipal = null;
    }

    public AuthenticationResult(AuthenticationStatus error, Exception cause) {
        this._status = error;
        this._challenge = null;
        this._cause = cause;
        this._mainPrincipal = null;
    }

    public AuthenticationResult(byte[] challenge, AuthenticationStatus status, Exception cause) {
        if (status == AuthenticationStatus.SUCCESS) {
            throw new IllegalArgumentException("Successful authentication requires at least one principal");
        }
        this._status = status;
        this._challenge = challenge;
        this._cause = cause;
        this._mainPrincipal = null;
    }

    public Exception getCause() {
        return this._cause;
    }

    public AuthenticationStatus getStatus() {
        return this._status;
    }

    public byte[] getChallenge() {
        return this._challenge;
    }

    public Set<Principal> getPrincipals() {
        return this._principals;
    }

    public Principal getMainPrincipal() {
        return this._mainPrincipal;
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        CONTINUE,
        ERROR;

    }
}

