/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.annotation.JacksonStdImpl;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.ser.std.ToStringSerializer;

@JacksonStdImpl
public final class BooleanSerializer
extends StdScalarSerializer<Object> {
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext serializers, BeanProperty property) {
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            JsonFormat.Shape shape = format.getShape();
            if (shape.isNumeric()) {
                return new AsNumber(this._forPrimitive);
            }
            if (shape == JsonFormat.Shape.STRING) {
                return new ToStringSerializer(this._handledType);
            }
        }
        return this;
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        g.writeBoolean(Boolean.TRUE.equals(value));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectBooleanFormat(typeHint);
    }

    static final class AsNumber
    extends StdScalarSerializer<Object> {
        protected final boolean _forPrimitive;

        public AsNumber(boolean forPrimitive) {
            super(forPrimitive ? Boolean.TYPE : Boolean.class, false);
            this._forPrimitive = forPrimitive;
        }

        @Override
        public ValueSerializer<?> createContextual(SerializationContext serializers, BeanProperty property) {
            JsonFormat.Shape shape;
            JsonFormat.Value format = this.findFormatOverrides(serializers, property, Boolean.class);
            if (format != null && !(shape = format.getShape()).isNumeric()) {
                return new BooleanSerializer(this._forPrimitive);
            }
            return this;
        }

        @Override
        public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            g.writeNumber(Boolean.FALSE.equals(value) ? 0 : 1);
        }

        @Override
        public final void serializeWithType(Object value, JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
            g.writeBoolean(Boolean.TRUE.equals(value));
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.INT);
        }
    }
}

