/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.server.protocol.v0_8.FlowCreditManager_0_8;

class Pre0_10CreditManager
implements FlowCreditManager_0_8 {
    private final long _highPrefetchLimit;
    private final long _batchLimit;
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    Pre0_10CreditManager(long bytesCreditLimit, long messageCreditLimit, long highPrefetchLimit, long batchLimit) {
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this._bytesCredit = bytesCreditLimit;
        this._messageCredit = messageCreditLimit;
        this._highPrefetchLimit = highPrefetchLimit;
        this._batchLimit = batchLimit;
    }

    void setCreditLimits(long bytesCreditLimit, long messageCreditLimit) {
        long bytesCreditChange = bytesCreditLimit - this._bytesCreditLimit;
        long messageCreditChange = messageCreditLimit - this._messageCreditLimit;
        if (bytesCreditChange != 0L) {
            this._bytesCredit += bytesCreditChange;
        }
        if (messageCreditChange != 0L) {
            this._messageCredit += messageCreditChange;
        }
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
    }

    public void restoreCredit(long messageCredit, long bytesCredit) {
        this._messageCredit += messageCredit;
        if (this._messageCredit > this._messageCreditLimit) {
            throw new IllegalStateException(String.format("Consumer credit accounting error. Restored more credit than we ever had: messageCredit=%d  messageCreditLimit=%d", this._messageCredit, this._messageCreditLimit));
        }
        this._bytesCredit += bytesCredit;
        if (this._bytesCredit > this._bytesCreditLimit) {
            throw new IllegalStateException(String.format("Consumer credit accounting error. Restored more credit than we ever had: bytesCredit=%d  bytesCreditLimit=%d", this._bytesCredit, this._bytesCreditLimit));
        }
    }

    public boolean hasCredit() {
        return !(this._bytesCreditLimit != 0L && this._bytesCredit <= 0L || this._messageCreditLimit != 0L && this._messageCredit <= 0L);
    }

    public boolean useCreditForMessage(long msgSize) {
        if (this._messageCreditLimit != 0L && this._messageCredit <= 0L) {
            return false;
        }
        if (this._bytesCreditLimit != 0L && this._bytesCredit < msgSize && this._bytesCredit != this._bytesCreditLimit) {
            return false;
        }
        --this._messageCredit;
        this._bytesCredit -= msgSize;
        return true;
    }

    @Override
    public boolean isNotBytesLimitedAndHighPrefetch() {
        return this._bytesCreditLimit == 0L && this._messageCreditLimit > this._highPrefetchLimit;
    }

    @Override
    public boolean isBytesLimited() {
        return this._bytesCredit != 0L;
    }

    @Override
    public boolean isCreditOverBatchLimit() {
        return this._messageCredit > this._batchLimit;
    }
}

