/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.conditional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.qpid.server.query.engine.exception.QueryValidationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;

public class CaseExpression<T, R>
extends AbstractExpressionNode<T, R> {
    final List<ExpressionNode<T, R>> _conditions;
    final List<ExpressionNode<T, R>> _outcomes;

    public CaseExpression(List<ExpressionNode<T, R>> conditions, List<ExpressionNode<T, R>> outcomes) {
        if (conditions.isEmpty()) {
            throw QueryValidationException.of("List of case operator conditions should not be empty", new Object[0]);
        }
        if (outcomes.isEmpty()) {
            throw QueryValidationException.of("List of case operator outcomes should not be empty", new Object[0]);
        }
        this._conditions = conditions;
        this._outcomes = outcomes;
        String alias = IntStream.range(0, conditions.size()).boxed().map(i -> "when " + ((ExpressionNode)conditions.get((int)i)).getAlias() + " then " + ((ExpressionNode)outcomes.get((int)i)).getAlias() + " ").collect(Collectors.joining("")) + "else " + outcomes.get(outcomes.size() - 1).getAlias();
        this._metadata.setAlias("case " + alias + " end");
    }

    @Override
    public R apply(T value) {
        for (int i = 0; i < this._conditions.size(); ++i) {
            Expression condition = this._conditions.get(i);
            if (!Objects.equals(Boolean.TRUE, condition.apply(value))) continue;
            return this._outcomes.get(i).apply(value);
        }
        return this._outcomes.get(this._outcomes.size() - 1).apply(value);
    }
}

